\ ANS Forth Exception Wordset
\ Contents Copyright (C) 1994 by Thomas Almy
\ Permission is granted to registered users of ForthCMP to sell or distribute
\ computer programs incorporating the compiled contents of this file.

\ The return stack is used as the exception stack. 
\ Information in the stack frame:
\  Pointer to next frame  (top of frame-- lowest address)
\  Saved SP
\  Saved IP 

VARIABLE exfp	\ Exception frame pointer

CODE CATCH 
  SI POP  AX POP  \ retAddr execAddr
  BP DEC BP DEC SI [BP] MOV
  BP DEC BP DEC SP [BP] MOV
  BP DEC BP DEC exfp [] BX MOV  BX [BP] MOV
  BP exfp [] MOV
  AX CALLI
  [BP] AX MOV  AX exfp [] MOV  
  AX AX XOR  AX PUSH
  4 +[BP] AX MOV  6 # BP ADD  
  AX JMPI
END-CODE

1 0 IN/OUT
CODE throw
  exfp [] BP MOV [BP] BX MOV BX exfp [] MOV
  2 +[BP] SP MOV  AX PUSH
  4 +[BP] AX MOV
  6 # BP ADD  AX JMPI
END-CODE

: THROW  ?DUP IF exfp @ IF throw THEN
       ." Uncaught THROW: " . BYE THEN ;


