/*
 * Decompiled with CFR 0.152.
 */
package us.almy.jelbum;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import us.almy.jelbum.AWord;
import us.almy.jelbum.JelbumSolver;

public class Jelbum
extends JFrame {
    JelbumSolver solver = new JelbumSolver();
    private JTextArea answerText;
    private JTextField characterField;
    private JButton clearCharacters;
    private JButton clearPattern;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JTextField patternField;
    private JButton solveButton;

    public Jelbum() {
        if (!this.solver.readWords()) {
            System.exit(1);
        }
        this.initComponents();
    }

    private void initComponents() {
        this.characterField = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.patternField = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.answerText = new JTextArea();
        this.solveButton = new JButton();
        this.clearCharacters = new JButton();
        this.clearPattern = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("Jelbum");
        this.jLabel1.setText("Characters:");
        this.jLabel2.setText("Pattern:");
        this.answerText.setEditable(false);
        this.answerText.setColumns(20);
        this.answerText.setRows(5);
        this.jScrollPane1.setViewportView(this.answerText);
        this.solveButton.setText("Solve");
        this.solveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Jelbum.this.solveButtonActionPerformed(evt);
            }
        });
        this.clearCharacters.setText("Clear");
        this.clearCharacters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Jelbum.this.clearCharactersActionPerformed(evt);
            }
        });
        this.clearPattern.setText("Clear");
        this.clearPattern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Jelbum.this.clearPatternActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 380, Short.MAX_VALUE).addGap(14, 14, 14)).addGroup(layout.createSequentialGroup().addComponent(this.solveButton).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.characterField).addComponent(this.patternField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.clearCharacters).addComponent(this.clearPattern, GroupLayout.Alignment.TRAILING)).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.characterField, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.clearCharacters)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.patternField, -2, -1, -2)).addComponent(this.clearPattern, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -2, 204, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.solveButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void solveButtonActionPerformed(ActionEvent evt) {
        this.setUpAndSolve();
    }

    private void clearCharactersActionPerformed(ActionEvent evt) {
        this.characterField.setText("");
    }

    private void clearPatternActionPerformed(ActionEvent evt) {
        this.patternField.setText("");
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Jelbum().setVisible(true);
            }
        });
    }

    private void setUpAndSolve() {
        String text = this.characterField.getText();
        String rawPattern = this.patternField.getText();
        LinkedList<Integer> pattern = new LinkedList<Integer>();
        LinkedList<String> answers = new LinkedList<String>();
        AWord target = this.solver.makeAWord(text);
        this.answerText.setText(null);
        if (target == null) {
            this.answerText.setText("Characters must all be lowercase");
            return;
        }
        int count = 0;
        int patternLength = 0;
        for (int i = rawPattern.length() - 1; i >= 0; --i) {
            boolean c;
            boolean bl = c = rawPattern.charAt(i) != ' ';
            if (c) {
                ++count;
                continue;
            }
            if (count <= 0) continue;
            pattern.addFirst(count);
            patternLength += count;
            count = 0;
        }
        if (count > 0) {
            pattern.addFirst(count);
            patternLength += count;
        }
        if (pattern.isEmpty()) {
            pattern.add(text.length());
            patternLength += text.length();
        }
        if (patternLength > text.length()) {
            this.answerText.setText("pattern too long");
            return;
        }
        this.solver.solve("", pattern, target, answers);
        if (answers.isEmpty()) {
            this.answerText.setText("No Solution Found");
        } else {
            Iterator it = answers.iterator();
            while (it.hasNext()) {
                this.answerText.append((String)it.next());
            }
        }
    }
}

