/*
 * Decompiled with CFR 0.152.
 */
package us.almy.mine;

import java.util.Random;

public class MinefieldModel {
    private static final int ACLEAR = 2;
    private static final int AMARK = 1;
    private static final int BOMB = -1;
    private static final int COVERED = 0;
    private static final int EXPOSED = 3;
    private static final int EXPOSEDBOMB = 3;
    private static final int EXPOSEDOFFSET = 4;
    private static final int FLAG = 1;
    private static final int NOTABOMB = 13;
    private static final int QMARK = 2;
    private static final int TCLEAR = -3;
    private static final int THID = -2;
    private static final int TNC = -1;
    private static int[][][] actions;
    private int bombsLeft;
    private int covered;
    private int[][] display;
    private static int[][][] rules;
    private static int[][] sizes;
    private int[][] value;
    private int xSize;
    private int ySize;

    static {
        sizes = new int[][]{{3, 3}, {3, 3}, {3, 3}, {3, 3}, {3, 4}, {3, 4}, {4, 3}, {4, 3}, {3, 5}, {3, 5}, {5, 3}, {5, 3}, {3, 4}, {3, 4}, {4, 3}, {4, 3}, {3, 4}, {3, 4}, {4, 3}, {4, 3}, {3, 4}, {3, 4}, {4, 3}, {4, 3}, {3, 4}, {3, 4}, {4, 3}, {4, 3}, {3, 5}, {3, 5}, {5, 3}, {5, 3}, {4, 3}, {4, 3}, {3, 4}, {3, 4}, {3, 4}, {3, 4}, {4, 3}, {4, 3}, {3, 4}, {3, 4}, {4, 3}, {4, 3}, {3, 5}, {3, 5}, {5, 3}, {5, 3}};
        rules = new int[48][][];
        actions = new int[48][][];
        MinefieldModel.rules[0] = new int[][]{{-3, -3, -3}, {1, 2, 1}, {-2, -2, -2}};
        MinefieldModel.actions[0] = new int[][]{{0, 0, 0}, {0, 0, 0}, {0, 2, 0}};
        MinefieldModel.rules[1] = MinefieldModel.flip(rules[0]);
        MinefieldModel.actions[1] = MinefieldModel.flip(actions[0]);
        MinefieldModel.rules[2] = MinefieldModel.rotate(rules[0]);
        MinefieldModel.actions[2] = MinefieldModel.rotate(actions[0]);
        MinefieldModel.rules[3] = MinefieldModel.rotate(rules[1]);
        MinefieldModel.actions[3] = MinefieldModel.rotate(actions[1]);
        MinefieldModel.rules[4] = new int[][]{{-3, -3, -3, -3}, {1, 2, 2, 1}, {-2, -2, -2, -2}};
        MinefieldModel.actions[4] = new int[][]{{0, 0, 0, 0}, {0, 0, 0, 0}, {2, 1, 1, 2}};
        MinefieldModel.rules[5] = MinefieldModel.flip(rules[4]);
        MinefieldModel.actions[5] = MinefieldModel.flip(actions[4]);
        MinefieldModel.rules[6] = MinefieldModel.rotate(rules[4]);
        MinefieldModel.actions[6] = MinefieldModel.rotate(actions[4]);
        MinefieldModel.rules[7] = MinefieldModel.rotate(rules[5]);
        MinefieldModel.actions[7] = MinefieldModel.rotate(actions[5]);
        MinefieldModel.rules[8] = new int[][]{{-3, -3, -3, -3, -3}, {-3, 1, 1, 1, -3}, {-3, -2, -2, -2, -3}};
        MinefieldModel.actions[8] = new int[][]{{0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 2, 1, 2, 0}};
        MinefieldModel.rules[9] = MinefieldModel.flip(rules[8]);
        MinefieldModel.actions[9] = MinefieldModel.flip(actions[8]);
        MinefieldModel.rules[10] = MinefieldModel.rotate(rules[8]);
        MinefieldModel.actions[10] = MinefieldModel.rotate(actions[8]);
        MinefieldModel.rules[11] = MinefieldModel.rotate(rules[9]);
        MinefieldModel.actions[11] = MinefieldModel.rotate(actions[9]);
        MinefieldModel.rules[12] = new int[][]{{-3, -3, -3, -3}, {-3, 1, 1, -3}, {-2, -2, -2, -3}};
        MinefieldModel.actions[12] = new int[][]{{0, 0, 0, 0}, {0, 0, 0, 0}, {2, 0, 0, 0}};
        MinefieldModel.rules[13] = MinefieldModel.flip(rules[12]);
        MinefieldModel.actions[13] = MinefieldModel.flip(actions[12]);
        MinefieldModel.rules[14] = MinefieldModel.rotate(rules[12]);
        MinefieldModel.actions[14] = MinefieldModel.rotate(actions[12]);
        MinefieldModel.rules[15] = MinefieldModel.rotate(rules[13]);
        MinefieldModel.actions[15] = MinefieldModel.rotate(actions[13]);
        MinefieldModel.rules[16] = new int[][]{{-3, -3, -3, -3}, {-3, 1, 1, -3}, {-3, -2, -2, -2}};
        MinefieldModel.actions[16] = new int[][]{{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 2}};
        MinefieldModel.rules[17] = MinefieldModel.flip(rules[16]);
        MinefieldModel.actions[17] = MinefieldModel.flip(actions[16]);
        MinefieldModel.rules[18] = MinefieldModel.rotate(rules[16]);
        MinefieldModel.actions[18] = MinefieldModel.rotate(actions[16]);
        MinefieldModel.rules[19] = MinefieldModel.rotate(rules[17]);
        MinefieldModel.actions[19] = MinefieldModel.rotate(actions[17]);
        MinefieldModel.rules[20] = new int[][]{{-3, -3, -3, -3}, {-3, 2, 1, -3}, {-2, -2, -2, -3}};
        MinefieldModel.actions[20] = new int[][]{{0, 0, 0, 0}, {0, 0, 0, 0}, {1, 0, 0, 0}};
        MinefieldModel.rules[21] = MinefieldModel.flip(rules[20]);
        MinefieldModel.actions[21] = MinefieldModel.flip(actions[20]);
        MinefieldModel.rules[22] = MinefieldModel.rotate(rules[20]);
        MinefieldModel.actions[22] = MinefieldModel.rotate(actions[20]);
        MinefieldModel.rules[23] = MinefieldModel.rotate(rules[21]);
        MinefieldModel.actions[23] = MinefieldModel.rotate(actions[21]);
        MinefieldModel.rules[24] = new int[][]{{-3, -3, -3, -3}, {-3, 1, 2, -3}, {-3, -2, -2, -2}};
        MinefieldModel.actions[24] = new int[][]{{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 1}};
        MinefieldModel.rules[25] = MinefieldModel.flip(rules[24]);
        MinefieldModel.actions[25] = MinefieldModel.flip(actions[24]);
        MinefieldModel.rules[26] = MinefieldModel.rotate(rules[24]);
        MinefieldModel.actions[26] = MinefieldModel.rotate(actions[24]);
        MinefieldModel.rules[27] = MinefieldModel.rotate(rules[25]);
        MinefieldModel.actions[27] = MinefieldModel.rotate(actions[25]);
        MinefieldModel.rules[28] = new int[][]{{-3, -3, -3, -3, -3}, {1, 2, 2, 2, 1}, {-2, -2, -2, -2, -2}};
        MinefieldModel.actions[28] = new int[][]{{0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 1, 0, 0}};
        MinefieldModel.rules[29] = MinefieldModel.flip(rules[28]);
        MinefieldModel.actions[29] = MinefieldModel.flip(actions[28]);
        MinefieldModel.rules[30] = MinefieldModel.rotate(rules[28]);
        MinefieldModel.actions[30] = MinefieldModel.rotate(actions[28]);
        MinefieldModel.rules[31] = MinefieldModel.rotate(rules[29]);
        MinefieldModel.actions[31] = MinefieldModel.rotate(actions[29]);
        MinefieldModel.rules[32] = new int[][]{{-3, -3, -3}, {1, 1, 1}, {-2, 1, -2}, {-2, -2, -2}};
        MinefieldModel.actions[32] = new int[][]{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {2, 2, 2}};
        MinefieldModel.rules[33] = MinefieldModel.flip(rules[32]);
        MinefieldModel.actions[33] = MinefieldModel.flip(actions[32]);
        MinefieldModel.rules[34] = MinefieldModel.rotate(rules[32]);
        MinefieldModel.actions[34] = MinefieldModel.rotate(actions[32]);
        MinefieldModel.rules[35] = MinefieldModel.rotate(rules[33]);
        MinefieldModel.actions[35] = MinefieldModel.rotate(actions[33]);
        MinefieldModel.rules[36] = new int[][]{{-3, -3, -3, -3}, {-3, 1, 1, 2}, {-3, -2, -2, -2}};
        MinefieldModel.actions[36] = new int[][]{{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 2}};
        MinefieldModel.rules[37] = MinefieldModel.flip(rules[36]);
        MinefieldModel.actions[37] = MinefieldModel.flip(actions[36]);
        MinefieldModel.rules[38] = MinefieldModel.rotate(rules[36]);
        MinefieldModel.actions[38] = MinefieldModel.rotate(actions[36]);
        MinefieldModel.rules[39] = MinefieldModel.rotate(rules[37]);
        MinefieldModel.actions[39] = MinefieldModel.rotate(actions[37]);
        MinefieldModel.rules[40] = new int[][]{{-3, -3, -3, -3}, {2, 1, 1, -3}, {-2, -2, -2, -3}};
        MinefieldModel.actions[40] = new int[][]{{0, 0, 0, 0}, {0, 0, 0, 0}, {2, 0, 0, 0}};
        MinefieldModel.rules[41] = MinefieldModel.flip(rules[40]);
        MinefieldModel.actions[41] = MinefieldModel.flip(actions[40]);
        MinefieldModel.rules[42] = MinefieldModel.rotate(rules[40]);
        MinefieldModel.actions[42] = MinefieldModel.rotate(actions[40]);
        MinefieldModel.rules[43] = MinefieldModel.rotate(rules[41]);
        MinefieldModel.actions[43] = MinefieldModel.rotate(actions[41]);
        MinefieldModel.rules[44] = new int[][]{{-3, -3, -3, -3, -3}, {-3, 2, 1, 2, -3}, {-2, -2, -2, -2, -2}};
        MinefieldModel.actions[44] = new int[][]{{0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 1, 0, 0}};
        MinefieldModel.rules[45] = MinefieldModel.flip(rules[44]);
        MinefieldModel.actions[45] = MinefieldModel.flip(actions[44]);
        MinefieldModel.rules[46] = MinefieldModel.rotate(rules[44]);
        MinefieldModel.actions[46] = MinefieldModel.rotate(actions[44]);
        MinefieldModel.rules[47] = MinefieldModel.rotate(rules[45]);
        MinefieldModel.actions[47] = MinefieldModel.rotate(actions[45]);
    }

    public MinefieldModel(int x, int y, int bombs) {
        int yp;
        int xp;
        this.display = new int[x + 2][y + 2];
        this.value = new int[x + 2][y + 2];
        this.xSize = x;
        this.ySize = y;
        this.bombsLeft = bombs;
        this.covered = x * y;
        Random r = new Random();
        while (bombs > 0) {
            xp = (int)Math.floor(r.nextDouble() * (double)x) + 1;
            if (this.value[xp][yp = (int)Math.floor(r.nextDouble() * (double)y) + 1] != 0) continue;
            --bombs;
            this.value[xp][yp] = -1;
        }
        xp = 1;
        while (xp <= this.xSize) {
            yp = 1;
            while (yp <= this.ySize) {
                if (this.value[xp][yp] == 0) {
                    if (this.value[xp - 1][yp - 1] < 0) {
                        int[] nArray = this.value[xp];
                        int n = yp;
                        nArray[n] = nArray[n] + 1;
                    }
                    if (this.value[xp][yp - 1] < 0) {
                        int[] nArray = this.value[xp];
                        int n = yp;
                        nArray[n] = nArray[n] + 1;
                    }
                    if (this.value[xp + 1][yp - 1] < 0) {
                        int[] nArray = this.value[xp];
                        int n = yp;
                        nArray[n] = nArray[n] + 1;
                    }
                    if (this.value[xp - 1][yp] < 0) {
                        int[] nArray = this.value[xp];
                        int n = yp;
                        nArray[n] = nArray[n] + 1;
                    }
                    if (this.value[xp + 1][yp] < 0) {
                        int[] nArray = this.value[xp];
                        int n = yp;
                        nArray[n] = nArray[n] + 1;
                    }
                    if (this.value[xp - 1][yp + 1] < 0) {
                        int[] nArray = this.value[xp];
                        int n = yp;
                        nArray[n] = nArray[n] + 1;
                    }
                    if (this.value[xp][yp + 1] < 0) {
                        int[] nArray = this.value[xp];
                        int n = yp;
                        nArray[n] = nArray[n] + 1;
                    }
                    if (this.value[xp + 1][yp + 1] < 0) {
                        int[] nArray = this.value[xp];
                        int n = yp;
                        nArray[n] = nArray[n] + 1;
                    }
                }
                ++yp;
            }
            ++xp;
        }
    }

    public void autoClear(int x, int y) {
        if (x < 1 || x > this.xSize || y < 1 || y > this.ySize || this.display[x][y] != 0) {
            return;
        }
        this.display[x][y] = this.value[x][y] + 4;
        --this.covered;
        if (this.covered > 0 && this.value[x][y] == 0) {
            this.autoClear(x - 1, y - 1);
            this.autoClear(x, y - 1);
            this.autoClear(x + 1, y - 1);
            this.autoClear(x - 1, y);
            this.autoClear(x + 1, y);
            this.autoClear(x - 1, y + 1);
            this.autoClear(x, y + 1);
            this.autoClear(x + 1, y + 1);
        }
    }

    public boolean clear(int x, int y) {
        if (this.display[x][y] != 0 || this.covered == 0) {
            return false;
        }
        if (x < 1 || x > this.xSize || y < 1 || y > this.ySize) {
            return false;
        }
        if (this.value[x][y] == -1) {
            this.display[x][y] = 3;
            int j = 1;
            while (j <= this.ySize) {
                int i = 1;
                while (i <= this.xSize) {
                    if (this.display[i][j] == 0 || this.display[i][j] == 2) {
                        if (this.value[i][j] == -1) {
                            this.display[i][j] = 3;
                        }
                    } else if (this.display[i][j] == 1 && this.value[i][j] != -1) {
                        this.display[i][j] = 13;
                        ++this.bombsLeft;
                    }
                    ++i;
                }
                ++j;
            }
            this.covered = 0;
            return true;
        }
        this.display[x][y] = this.value[x][y] + 4;
        --this.covered;
        if (this.covered > 0 && this.value[x][y] == 0) {
            this.autoClear(x - 1, y - 1);
            this.autoClear(x, y - 1);
            this.autoClear(x + 1, y - 1);
            this.autoClear(x - 1, y);
            this.autoClear(x + 1, y);
            this.autoClear(x - 1, y + 1);
            this.autoClear(x, y + 1);
            this.autoClear(x + 1, y + 1);
        }
        return true;
    }

    private int covered(int x, int y) {
        int result = 0;
        if (y > 1) {
            if (this.display[x - 1][y - 1] < 3 && x > 1) {
                ++result;
            }
            if (this.display[x][y - 1] < 3) {
                ++result;
            }
            if (this.display[x + 1][y - 1] < 3 && x < this.xSize) {
                ++result;
            }
        }
        if (this.display[x - 1][y] < 3 && x > 1) {
            ++result;
        }
        if (this.display[x + 1][y] < 3 && x < this.xSize) {
            ++result;
        }
        if (y < this.ySize) {
            if (this.display[x - 1][y + 1] < 3 && x > 1) {
                ++result;
            }
            if (this.display[x][y + 1] < 3) {
                ++result;
            }
            if (this.display[x + 1][y + 1] < 3 && x < this.xSize) {
                ++result;
            }
        }
        return result;
    }

    public boolean firstOrderClear() {
        boolean success = false;
        if (this.bombsLeft == 0 && this.covered > 0) {
            int x = 1;
            while (x <= this.xSize) {
                int y = 1;
                while (y <= this.ySize) {
                    if (this.display[x][y] == 0) {
                        this.clear(x, y);
                    } else if (this.display[x][y] == 2) {
                        this.toggle(x, y);
                        this.clear(x, y);
                    }
                    ++y;
                }
                ++x;
            }
            return true;
        }
        int x = 1;
        while (x <= this.xSize) {
            int y = 1;
            while (y <= this.ySize) {
                if (this.display[x][y] > 4 && this.flagged(x, y) == this.display[x][y] - 4) {
                    success |= this.clear(x - 1, y - 1);
                    success |= this.clear(x, y - 1);
                    success |= this.clear(x + 1, y - 1);
                    success |= this.clear(x - 1, y);
                    success |= this.clear(x + 1, y);
                    success |= this.clear(x - 1, y + 1);
                    success |= this.clear(x, y + 1);
                    success |= this.clear(x + 1, y + 1);
                }
                ++y;
            }
            ++x;
        }
        if (success) {
            this.firstOrderClear();
        }
        return success;
    }

    private int flagged(int x, int y) {
        int result = 0;
        if (this.display[x - 1][y - 1] == 1) {
            ++result;
        }
        if (this.display[x][y - 1] == 1) {
            ++result;
        }
        if (this.display[x + 1][y - 1] == 1) {
            ++result;
        }
        if (this.display[x - 1][y] == 1) {
            ++result;
        }
        if (this.display[x + 1][y] == 1) {
            ++result;
        }
        if (this.display[x - 1][y + 1] == 1) {
            ++result;
        }
        if (this.display[x][y + 1] == 1) {
            ++result;
        }
        if (this.display[x + 1][y + 1] == 1) {
            ++result;
        }
        return result;
    }

    private static int[][] flip(int[][] arg) {
        int xsize = arg.length;
        int[][] result = new int[xsize][];
        int i = 0;
        while (i < xsize) {
            result[i] = arg[xsize - 1 - i];
            ++i;
        }
        return result;
    }

    public int getBombsLeft() {
        return this.bombsLeft;
    }

    public int getCovered() {
        return this.covered;
    }

    public int[][] getDisplay() {
        return this.display;
    }

    public int getXSize() {
        return this.xSize;
    }

    public int getYSize() {
        return this.ySize;
    }

    public boolean opsClear(int x, int y) {
        if (x < 1 || x > this.xSize || y < 1 || y > this.ySize) {
            return false;
        }
        if (this.value[x][y] == -1) {
            this.toggle(x, y);
            return true;
        }
        return this.clear(x, y);
    }

    public boolean quickStart() {
        int yp;
        int xp;
        Random r = new Random();
        while (this.value[xp = (int)Math.floor(r.nextDouble() * (double)this.xSize) + 1][yp = (int)Math.floor(r.nextDouble() * (double)this.ySize) + 1] != 0) {
        }
        return this.clear(xp, yp);
    }

    private static int[][] rotate(int[][] arg) {
        int xsize = arg.length;
        int ysize = arg[0].length;
        int[][] result = new int[ysize][xsize];
        int i = 0;
        while (i < xsize) {
            int j = 0;
            while (j < ysize) {
                result[j][i] = arg[i][j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public boolean secondOrderMark() {
        boolean success = false;
        if (this.bombsLeft == this.covered && this.bombsLeft > 0) {
            int x = 1;
            while (x <= this.xSize) {
                int y = 1;
                while (y <= this.ySize) {
                    if (this.display[x][y] == 0) {
                        this.toggle(x, y);
                    } else if (this.display[x][y] == 2) {
                        this.toggle(x, y);
                        this.toggle(x, y);
                    }
                    ++y;
                }
                ++x;
            }
            return true;
        }
        int x = 1;
        while (x <= this.xSize) {
            int y = 1;
            while (y <= this.ySize) {
                if (this.display[x][y] > 4 && this.covered(x, y) == this.display[x][y] - 4) {
                    if (this.display[x - 1][y - 1] == 2) {
                        this.toggle(x - 1, y - 1);
                    }
                    if (this.display[x][y - 1] == 2) {
                        this.toggle(x, y - 1);
                    }
                    if (this.display[x + 1][y - 1] == 2) {
                        this.toggle(x + 1, y - 1);
                    }
                    if (this.display[x - 1][y] == 2) {
                        this.toggle(x - 1, y);
                    }
                    if (this.display[x + 1][y] == 2) {
                        this.toggle(x + 1, y);
                    }
                    if (this.display[x - 1][y + 1] == 2) {
                        this.toggle(x - 1, y + 1);
                    }
                    if (this.display[x][y + 1] == 2) {
                        this.toggle(x, y + 1);
                    }
                    if (this.display[x + 1][y + 1] == 2) {
                        this.toggle(x + 1, y + 1);
                    }
                    if (this.display[x - 1][y - 1] == 0) {
                        success |= this.toggle(x - 1, y - 1);
                    }
                    if (this.display[x][y - 1] == 0) {
                        success |= this.toggle(x, y - 1);
                    }
                    if (this.display[x + 1][y - 1] == 0) {
                        success |= this.toggle(x + 1, y - 1);
                    }
                    if (this.display[x - 1][y] == 0) {
                        success |= this.toggle(x - 1, y);
                    }
                    if (this.display[x + 1][y] == 0) {
                        success |= this.toggle(x + 1, y);
                    }
                    if (this.display[x - 1][y + 1] == 0) {
                        success |= this.toggle(x - 1, y + 1);
                    }
                    if (this.display[x][y + 1] == 0) {
                        success |= this.toggle(x, y + 1);
                    }
                    if (this.display[x + 1][y + 1] == 0) {
                        success |= this.toggle(x + 1, y + 1);
                    }
                }
                ++y;
            }
            ++x;
        }
        return success;
    }

    private int thirdCheck(int x, int y) {
        int count = this.display[x][y] - 4;
        if (count < 0) {
            return 0;
        }
        if (this.display[x - 1][y - 1] == 1 || this.display[x - 1][y - 1] == 2) {
            --count;
        }
        if (this.display[x][y - 1] == 1 || this.display[x][y - 1] == 2) {
            --count;
        }
        if (this.display[x + 1][y - 1] == 1 || this.display[x + 1][y - 1] == 2) {
            --count;
        }
        if (this.display[x - 1][y] == 1 || this.display[x - 1][y] == 2) {
            --count;
        }
        if (this.display[x + 1][y] == 1 || this.display[x + 1][y] == 2) {
            --count;
        }
        if (this.display[x - 1][y + 1] == 1 || this.display[x - 1][y + 1] == 2) {
            --count;
        }
        if (this.display[x][y + 1] == 1 || this.display[x][y + 1] == 2) {
            --count;
        }
        if (this.display[x + 1][y + 1] == 1 || this.display[x + 1][y + 1] == 2) {
            --count;
        }
        return count;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    public boolean thirdOrderClear() {
        boolean success;
        boolean main_success = false;
        do {
            success = false;
            int test = 0;
            while (test < rules.length) {
                int x = 0;
                while (x < this.xSize + 2 - sizes[test][0]) {
                    int y = 0;
                    while (y < this.ySize + 2 - sizes[test][1]) {
                        boolean isCandidate = true;
                        int i = 0;
                        while (i < sizes[test][0] && isCandidate) {
                            int j = 0;
                            boolean bl = true;
                            do {
                                if (!bl || (bl = false) || !true) {
                                    int ix = i + x;
                                    int jy = j + y;
                                    switch (rules[test][i][j]) {
                                        case -3: {
                                            if (ix <= 0 || ix > this.xSize || jy <= 0 || jy > this.ySize || this.display[ix][jy] != 0 && this.display[ix][jy] != 2) break;
                                            isCandidate = false;
                                            break;
                                        }
                                        case -2: {
                                            if (ix == 0 || ix == this.xSize + 1 || jy == 0 || jy == this.ySize + 1 || this.display[ix][jy] != 0 && this.display[ix][jy] != 2) {
                                                isCandidate = false;
                                            }
                                        }
                                        case -1: {
                                            break;
                                        }
                                        default: {
                                            if (this.thirdCheck(ix, jy) == rules[test][i][j]) break;
                                            isCandidate = false;
                                        }
                                    }
                                    ++j;
                                }
                                if (j >= sizes[test][1]) break;
                            } while (isCandidate);
                            ++i;
                        }
                        if (isCandidate) {
                            int i2 = 0;
                            while (i2 < sizes[test][0]) {
                                int j = 0;
                                while (j < sizes[test][1]) {
                                    int ix = i2 + x;
                                    int jy = j + y;
                                    switch (actions[test][i2][j]) {
                                        case 1: {
                                            if (this.display[ix][jy] == 2) {
                                                this.toggle(ix, jy);
                                            }
                                            this.toggle(ix, jy);
                                            break;
                                        }
                                        case 2: {
                                            this.clear(ix, jy);
                                            break;
                                        }
                                    }
                                    ++j;
                                }
                                ++i2;
                            }
                            success = true;
                        }
                        ++y;
                    }
                    ++x;
                }
                ++test;
            }
            main_success |= success;
        } while (success);
        return main_success;
    }

    public boolean toggle(int x, int y) {
        if (x < 1 || x > this.xSize || y < 1 || y > this.ySize) {
            return false;
        }
        switch (this.display[x][y]) {
            case 0: {
                if (this.bombsLeft == 0) {
                    return false;
                }
                this.display[x][y] = 1;
                --this.bombsLeft;
                --this.covered;
                break;
            }
            case 1: {
                this.display[x][y] = 2;
                ++this.bombsLeft;
                ++this.covered;
                break;
            }
            case 2: {
                this.display[x][y] = 0;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

