/*
 * Decompiled with CFR 0.152.
 */
package us.almy.mine;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.net.URL;
import us.almy.mine.MinefieldModel;

public class MinefieldView
extends Canvas {
    private boolean buffered = false;
    private static final String[] files = new String[]{"s.gif", "f.gif", "q.gif", "b.gif", "0.gif", "1.gif", "2.gif", "3.gif", "4.gif", "5.gif", "6.gif", "7.gif", "8.gif", "nb.gif"};
    private int h = 20;
    private Image[] images = new Image[14];
    private MediaTracker loadImages;
    private MinefieldModel model;
    private Graphics offScreenGraphic;
    private Image offScreenImage;
    private int[][] oldDisplay;
    private int w = 20;

    public MinefieldView() {
        this.initialize();
    }

    public static Point convertCoordinates(Point p) {
        return new Point(p.x / 20 + 1, p.y / 20 + 1);
    }

    public MinefieldModel getModel() {
        return this.model;
    }

    private void initialize() {
        this.loadImages = new MediaTracker(this);
        int i = 0;
        while (i < this.images.length) {
            try {
                URL url = this.getClass().getResource(files[i]);
                this.images[i] = this.createImage((ImageProducer)url.getContent());
                this.loadImages.addImage(this.images[i], i);
            }
            catch (IOException e) {
                System.out.println(" Could not read " + files[i]);
            }
            ++i;
        }
        try {
            this.loadImages.waitForAll();
        }
        catch (InterruptedException e) {
            System.out.println("Image Loading Failed!");
        }
    }

    public boolean isBuffered() {
        return this.buffered;
    }

    public void paint(Graphics g) {
        try {
            if (this.isBuffered()) {
                if (this.offScreenImage == null) {
                    return;
                }
                g.drawImage(this.offScreenImage, 0, 0, this);
            } else if (this.model.getDisplay() != null) {
                int j = 1;
                while (j <= this.h) {
                    int i = 1;
                    while (i <= this.w) {
                        g.drawImage(this.images[this.model.getDisplay()[i][j]], (i - 1) * 20, (j - 1) * 20, null);
                        ++i;
                    }
                    ++j;
                }
            }
        }
        catch (NullPointerException ex) {
        }
    }

    public void setBuffered(boolean buffered) {
        this.buffered = buffered;
    }

    public void setModel(MinefieldModel newValue) {
        this.model = newValue;
        if (this.w != newValue.getXSize() || this.h != newValue.getYSize()) {
            this.w = newValue.getXSize();
            this.h = newValue.getYSize();
            this.setSize(this.w * 20, this.h * 20);
            this.offScreenImage = null;
            this.oldDisplay = new int[this.w + 2][this.h + 2];
            int i = 1;
            while (i <= this.w) {
                int j = 1;
                while (j <= this.h) {
                    this.oldDisplay[i][j] = -1;
                    ++j;
                }
                ++i;
            }
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void updateChanges() {
        if (this.isBuffered()) {
            if (this.offScreenImage == null) {
                this.offScreenImage = this.createImage(this.w * 20, this.h * 20);
                this.offScreenGraphic = this.offScreenImage.getGraphics();
                this.offScreenGraphic.setColor(Color.white);
                this.offScreenGraphic.fillRect(0, 0, this.w * 20, this.h * 20);
            }
            int j = 1;
            while (j <= this.h) {
                int i = 1;
                while (i <= this.w) {
                    int temp = this.model.getDisplay()[i][j];
                    if (temp != this.oldDisplay[i][j]) {
                        this.offScreenGraphic.drawImage(this.images[temp], (i - 1) * 20, (j - 1) * 20, null);
                        this.oldDisplay[i][j] = temp;
                    }
                    ++i;
                }
                ++j;
            }
        }
        this.repaint();
    }
}

