/*
 * Decompiled with CFR 0.152.
 */
package sudoku;

import java.util.ArrayList;
import java.util.Collections;
import sudoku.Chooser;
import sudoku.Field;
import sudoku.MultipleSolutionException;

public class PlayEngine {
    private Field _f;
    private boolean _noBacktrack = false;
    private boolean _checkMultiples = false;
    public static final int NO_SOLUTION = 0;
    public static final int EASY_SOLUTION = 1;
    public static final int HARD_SOLUTION = 2;

    public void setNoBacktrack() {
        this._noBacktrack = true;
    }

    public void setCheckMultiples(boolean check) {
        this._checkMultiples = check;
    }

    public PlayEngine(Field field) {
        this._f = field;
    }

    public static int verify(Field f) {
        int state = f.getState();
        switch (state) {
            case 1: {
                return 0;
            }
            case 0: {
                return 1;
            }
        }
        Field new_f = new Field(f);
        PlayEngine p = new PlayEngine(new_f);
        p.setNoBacktrack();
        try {
            new_f = p.playUntilSolvedOrQuit();
        }
        catch (MultipleSolutionException ex) {
            // empty catch block
        }
        if (new_f == null) {
            return 0;
        }
        state = new_f.getState();
        switch (state) {
            case 1: {
                return 0;
            }
            case 0: {
                return 1;
            }
        }
        new_f = new Field(f);
        p = new PlayEngine(new_f);
        try {
            new_f = p.playUntilSolvedOrQuit();
        }
        catch (MultipleSolutionException ex) {
            // empty catch block
        }
        if (new_f == null) {
            return 0;
        }
        return 2;
    }

    public Field playUntilSolvedOrQuit() throws MultipleSolutionException {
        int bestPos;
        this._f.calculatePossibles();
        while (true) {
            bestPos = 0;
            int bestVal = 10;
            int bestCount = 0;
            for (int i = 0; i < 81; ++i) {
                if (this._f.squares[i] != 0) continue;
                if (this._f.possiblesCount[i] < bestVal) {
                    bestPos = i;
                    bestCount = 0;
                    bestVal = this._f.possiblesCount[i];
                    continue;
                }
                if (this._f.possiblesCount[i] != bestVal) continue;
                ++bestCount;
            }
            if (bestVal == 10) {
                return this._f;
            }
            if (bestVal == 0) {
                return null;
            }
            if (bestVal != 1) break;
            int choice = 0;
            switch (this._f.possibles[bestPos]) {
                case 1: {
                    choice = 1;
                    break;
                }
                case 2: {
                    choice = 2;
                    break;
                }
                case 4: {
                    choice = 3;
                    break;
                }
                case 8: {
                    choice = 4;
                    break;
                }
                case 16: {
                    choice = 5;
                    break;
                }
                case 32: {
                    choice = 6;
                    break;
                }
                case 64: {
                    choice = 7;
                    break;
                }
                case 128: {
                    choice = 8;
                    break;
                }
                case 256: {
                    choice = 9;
                    break;
                }
                default: {
                    System.out.println("No valid choice in " + this._f.possibles[bestPos]);
                }
            }
            this._f.fillAt(bestPos, choice);
            this._f.calculatePossibles();
        }
        if (this._noBacktrack) {
            return this._f;
        }
        int possibles = this._f.possibles[bestPos];
        int trial = 1;
        int alternatives = 0;
        Field newField = null;
        do {
            if ((possibles & 1 << trial - 1) == 0) continue;
            newField = new Field(this._f);
            newField.fillAt(bestPos, trial);
            PlayEngine p = new PlayEngine(newField);
            p.setCheckMultiples(this._checkMultiples);
            newField = p.playUntilSolvedOrQuit();
            if (newField == null) continue;
            if (this._checkMultiples) {
                if (++alternatives <= 1) continue;
                throw new MultipleSolutionException();
            }
            return newField;
        } while (++trial < 10);
        if (this._checkMultiples && alternatives == 1) {
            return new Field();
        }
        return null;
    }

    public Field playRandomlyUntilSolvedOrQuit() {
        ArrayList<Integer> choices;
        this._f.calculatePossibles();
        while (true) {
            int bestVal = 10;
            choices = new ArrayList<Integer>();
            for (int i = 0; i < 81; ++i) {
                if (this._f.squares[i] != 0) continue;
                if (this._f.possiblesCount[i] < bestVal) {
                    choices.clear();
                    choices.add(i);
                    bestVal = this._f.possiblesCount[i];
                    continue;
                }
                if (this._f.possiblesCount[i] != bestVal) continue;
                choices.add(i);
            }
            if (bestVal == 10) {
                return this._f;
            }
            if (bestVal == 0) {
                return null;
            }
            if (bestVal != 1) break;
            int choice = 0;
            Collections.shuffle(choices, Chooser.getChooser().getRandom());
            int bestPos = (Integer)choices.get(0);
            switch (this._f.possibles[bestPos]) {
                case 1: {
                    choice = 1;
                    break;
                }
                case 2: {
                    choice = 2;
                    break;
                }
                case 4: {
                    choice = 3;
                    break;
                }
                case 8: {
                    choice = 4;
                    break;
                }
                case 16: {
                    choice = 5;
                    break;
                }
                case 32: {
                    choice = 6;
                    break;
                }
                case 64: {
                    choice = 7;
                    break;
                }
                case 128: {
                    choice = 8;
                    break;
                }
                case 256: {
                    choice = 9;
                    break;
                }
                default: {
                    System.out.println("No valid choice in " + this._f.possibles[bestPos]);
                }
            }
            this._f.fillAt(bestPos, choice);
            this._f.calculatePossibles();
        }
        if (this._noBacktrack) {
            return this._f;
        }
        int bestPos = (Integer)choices.get(Chooser.getChooser().nextInt(choices.size()));
        int possibles = this._f.possibles[bestPos];
        choices.clear();
        for (int i = 0; i < 9; ++i) {
            if ((possibles & 1 << i) == 0) continue;
            choices.add(i + 1);
        }
        for (Integer trialObj : choices) {
            int trial = trialObj;
            Field newField = new Field(this._f);
            newField.fillAt(bestPos, trial);
            PlayEngine p = new PlayEngine(newField);
            if ((newField = p.playRandomlyUntilSolvedOrQuit()) == null) continue;
            return newField;
        }
        return null;
    }
}

