/*
 * Decompiled with CFR 0.152.
 */
package sudoku;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import sudoku.Field;

public class ViewScreen
extends JComponent
implements FocusListener,
MouseListener {
    private static final int[] PHYS_TO_LOG = new int[]{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8};
    private static final int[] LOG_TO_PHYS = new int[]{0, 1, 2, 4, 5, 6, 8, 9, 10};
    private static final int COLUMNS = 11;
    private static final int ROWS = 11;
    private int _charWidth;
    private int _ascent;
    private int _descent;
    private int _charHeight;
    private int _leading;
    private Dimension _minimumSize = new Dimension(0, 0);
    private Image _offscreen;
    private int _curx = 0;
    private int _cury = 0;
    private boolean _curVis = false;
    private boolean _gotFocus = false;
    private Color _controlColor;
    private Color _controlTextColor;
    private Color _controlLockedColor;
    private boolean _hinting = false;

    public void setHinting(boolean value) {
        this._hinting = value;
    }

    public ViewScreen() {
        this.setSize(560, 375);
        JPanel temp = new JPanel();
        int fontSize = (int)((double)temp.getFont().getSize() * 1.5);
        this._controlColor = Color.GRAY;
        this._controlTextColor = temp.getForeground();
        this._controlLockedColor = Color.PINK;
        Font f = new Font("Monospaced", 1, fontSize);
        this.setFont(f);
        FontMetrics fm = this.getFontMetrics(f);
        this._ascent = fm.getAscent();
        this._descent = fm.getDescent();
        this._leading = fm.getLeading();
        this._charHeight = fm.getHeight() + 2;
        this._charWidth = fm.charWidth('A') * 2;
        int desiredHeight = 11 * this._charHeight;
        int desiredWidth = 11 * this._charWidth;
        this.setSize(desiredWidth, desiredHeight);
        this._minimumSize = new Dimension(desiredWidth, desiredHeight);
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.setRequestFocusEnabled(true);
    }

    private void cursorOff(Graphics g) {
        if (this._curVis) {
            this._curVis = false;
            g.setColor(this.getBackground());
            g.setXORMode(Color.red);
            g.fillRect(this._curx * this._charWidth, this._cury * this._charHeight, this._charWidth, this._charHeight);
            this.repaint(this._curx * this._charWidth, this._cury * this._charHeight, this._charWidth, this._charHeight);
            g.setPaintMode();
            g.setColor(this.getForeground());
        }
    }

    private void cursorOn(Graphics g) {
        if (this._gotFocus) {
            this._curVis = true;
            g.setColor(this.getBackground());
            g.setXORMode(Color.red);
            g.fillRect(this._curx * this._charWidth, this._cury * this._charHeight, this._charWidth, this._charHeight);
            this.repaint(this._curx * this._charWidth, this._cury * this._charHeight, this._charWidth, this._charHeight);
            g.setPaintMode();
            g.setColor(this.getForeground());
        }
    }

    public void focusGained(FocusEvent e) {
        if (this._offscreen == null) {
            return;
        }
        if (!this._gotFocus) {
            this._gotFocus = true;
            if (this._curVis) {
                return;
            }
            this._curVis = true;
            Graphics g = this._offscreen.getGraphics();
            g.setColor(this.getBackground());
            g.setXORMode(Color.red);
            g.fillRect(this._curx * this._charWidth, this._cury * this._charHeight, this._charWidth, this._charHeight);
            this.repaint(this._curx * this._charWidth, this._cury * this._charHeight, this._charWidth, this._charHeight);
            g.setPaintMode();
            g.setColor(this.getForeground());
            g.dispose();
        }
    }

    public void focusLost(FocusEvent e) {
        if (this._gotFocus) {
            this._gotFocus = false;
            if (!this._curVis) {
                return;
            }
            this._curVis = false;
            Graphics g = this._offscreen.getGraphics();
            g.setColor(this.getBackground());
            g.setXORMode(Color.red);
            g.fillRect(this._curx * this._charWidth, this._cury * this._charHeight, this._charWidth, this._charHeight);
            this.repaint(this._curx * this._charWidth, this._cury * this._charHeight, this._charWidth, this._charHeight);
            g.setPaintMode();
            g.setColor(this.getForeground());
            this.paint(g);
            g.dispose();
        }
    }

    private Point getCoordinates(Point p) {
        int row = p.x / this._charWidth;
        int col = p.y / this._charHeight;
        return new Point(row, col);
    }

    public Point getLogCursorPosition() {
        return new Point(PHYS_TO_LOG[this._curx], PHYS_TO_LOG[this._cury]);
    }

    public Dimension getMinimumSize() {
        return this._minimumSize;
    }

    public Dimension getPreferredSize() {
        return this._minimumSize;
    }

    public boolean isFocusable() {
        return true;
    }

    private void makeScreen() {
        if (this._offscreen != null) {
            return;
        }
        int desiredWidth = this._minimumSize.width;
        int desiredHeight = this._minimumSize.height;
        Frame frame = new Frame();
        frame.addNotify();
        frame.setFont(this.getFont());
        this._offscreen = frame.createImage(desiredWidth, desiredHeight);
        Graphics g = this._offscreen.getGraphics();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, desiredWidth, desiredHeight);
        g.setColor(this._controlColor);
        g.fillRect(0, 3 * this._charHeight, this._charWidth * 11, this._charHeight);
        g.fillRect(0, 7 * this._charHeight, this._charWidth * 11, this._charHeight);
        g.fillRect(3 * this._charWidth, 0, this._charWidth, this._charHeight * 11);
        g.fillRect(7 * this._charWidth, 0, this._charWidth, this._charHeight * 11);
        this.cursorOn(g);
        g.setColor(this.getForeground());
        g.dispose();
        frame.dispose();
        this.requestFocus();
    }

    public void paintComponent(Graphics g) {
        if (this._offscreen == null) {
            this.makeScreen();
        }
        g.drawImage(this._offscreen, 0, 0, null);
    }

    public void putText(int x, int y, Field f) {
        if (this._offscreen == null) {
            this.makeScreen();
        }
        Graphics g = this._offscreen.getGraphics();
        this.cursorOff(g);
        int px = LOG_TO_PHYS[x];
        int py = LOG_TO_PHYS[y];
        int index = Field.coordinatesToIndex(x, y);
        if (this._hinting) {
            switch (f.hintValue(index)) {
                case 0: {
                    g.setColor(this.getBackground());
                    break;
                }
                case 1: {
                    g.setColor(Color.GREEN);
                    break;
                }
                case 2: {
                    g.setColor(Color.YELLOW);
                }
            }
        } else {
            g.setColor(this.getBackground());
        }
        g.fillRect(px * this._charWidth, py * this._charHeight, this._charWidth, this._charHeight);
        if (f.isLocked(index)) {
            g.setColor(this._controlLockedColor);
        } else {
            g.setColor(this._controlTextColor);
        }
        g.drawString(f.squares[index] == 0 ? " " : Integer.toString(f.squares[index]), (int)((double)(px * this._charWidth) + (double)this._charWidth * 0.3), py * this._charHeight + this._ascent);
        this.repaint(px * this._charWidth, py * this._charHeight, this._charWidth, this._charHeight);
        this.cursorOn(g);
        g.dispose();
    }

    public void drawAll(Field f) {
        for (int i = 0; i < 81; ++i) {
            int y = Field.indexToRow(i);
            int x = Field.indexToColumn(i);
            this.putText(x, y, f);
        }
    }

    private void setCursorPosition(int x, int y) {
        if (x != this._curx || y != this._cury) {
            Graphics g = this._offscreen.getGraphics();
            this.cursorOff(g);
            this._curx = x;
            this._cury = y;
            this.cursorOn(g);
            g.dispose();
        }
    }

    public void setLogCursorPosition(int x, int y) {
        this.setCursorPosition(LOG_TO_PHYS[x], LOG_TO_PHYS[y]);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void mouseClicked(MouseEvent e) {
        Point p = this.getCoordinates(e.getPoint());
        e.consume();
        this.requestFocus();
        int xPos = p.x;
        if (xPos == 3) {
            xPos = 4;
        } else if (xPos == 7) {
            xPos = 8;
        }
        int yPos = p.y;
        if (yPos == 3) {
            yPos = 4;
        } else if (yPos == 7) {
            yPos = 8;
        }
        this.setCursorPosition(xPos, yPos);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        e.consume();
        this.requestFocus();
    }

    public void mouseReleased(MouseEvent e) {
    }
}

