package sudoku;

/** The Chooser class is just a singleton random number generator.
 * We don't want to create a new Random object every time we want a random number.
 * @author thomas.almy
 */
public class Chooser {
    private static Chooser _ch = null;
    private java.util.Random _random;

    /**
     * Private constructor since we only want to create a new Chooser if none
     * already exist.
     */
    private Chooser() {
        _random = new java.util.Random();
    };

    /**
     * Static method which returns the (singleton) Chooser object.
     * @return the Chooser object
     */
    public static Chooser getChooser() {
        if (_ch == null) _ch = new Chooser();
        return _ch;
    }

    /**
     * Getter for the Random object, so any java.util.Random method can be used.
     * @return the sole Random object
     */
    public java.util.Random getRandom() { return _random; }

    /**
     * Create a random integer between 0 (inclusive) and i (exclusive).
     * @param i
     * @return the random integer
     */
    public int nextInt(int i) { return _random.nextInt(i); }
}
