/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package sudoku;

/**
 * The state of a Sudoku game. SUCCESS means all locations successfully filled
 * in. FAIL means that there are empty locations with no possible values.
 * IN_PROGRESS means that there are empty locations and they all have possible values.
 * @author thomas.almy
 */
public enum GameState {
    /**
     * All locations successfully filled in
     */
    SUCCESS,
    /**
     * Puzzle is not solvable with current values because of conflicts
     */
    FAIL,
    /**
     * Puzzle in progress -- there are empty locations and they all have possible values.
     * But tthat doesn't mean a solution exists.
     */
    IN_PROGRESS
}
