package sudoku;

import java.awt.Point;
import java.util.ArrayList;

/**
 * PlayPanel is the GUI for the Sudoku game.
 * @author thomas.almy
 */
public class PlayPanel extends javax.swing.JPanel {

    private Field _f;

    /** Creates new form PlayPanel */
    public PlayPanel() {
        _f = new Field();
        _f.calculatePossibles();  // initialize everything in the field
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        viewScreen = new sudoku.ViewScreen();
        jPanel1 = new javax.swing.JPanel();
        jButtonClear = new javax.swing.JButton();
        jToggleButtonLocked = new javax.swing.JToggleButton();
        jButtonPlayNoRetry = new javax.swing.JButton();
        jButtonPlay = new javax.swing.JButton();
        jButtonValidate = new javax.swing.JButton();
        jButtonCreate = new javax.swing.JButton();
        jButtonDifficult = new javax.swing.JButton();
        jToggleButtonHints = new javax.swing.JToggleButton();
        jLabelStatus = new javax.swing.JLabel();

        setLayout(new java.awt.BorderLayout());

        viewScreen.setBackground(java.awt.Color.white);
        viewScreen.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                viewScreenKeyTyped(evt);
            }
        });
        add(viewScreen, java.awt.BorderLayout.CENTER);

        jPanel1.setLayout(new java.awt.GridBagLayout());

        jButtonClear.setText("Clear");
        jButtonClear.setToolTipText("Clear puzzle field");
        jButtonClear.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonClearActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add(jButtonClear, gridBagConstraints);

        jToggleButtonLocked.setText("Lock");
        jToggleButtonLocked.setToolTipText("lock/unlock current values as hints");
        jToggleButtonLocked.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToggleButtonLockedActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add(jToggleButtonLocked, gridBagConstraints);

        jButtonPlayNoRetry.setText("Play forced");
        jButtonPlayNoRetry.setToolTipText("Fill in locations with values that are forced");
        jButtonPlayNoRetry.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonPlayNoRetryActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add(jButtonPlayNoRetry, gridBagConstraints);

        jButtonPlay.setText("Solve");
        jButtonPlay.setToolTipText("Exhaustive search for solution");
        jButtonPlay.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonPlayActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add(jButtonPlay, gridBagConstraints);

        jButtonValidate.setText("Validate");
        jButtonValidate.setToolTipText("Is puzzle solvable?");
        jButtonValidate.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonValidateActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add(jButtonValidate, gridBagConstraints);

        jButtonCreate.setText("Create puzzle");
        jButtonCreate.setToolTipText("Easy puzzle solvable by forced values only");
        jButtonCreate.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCreateActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add(jButtonCreate, gridBagConstraints);

        jButtonDifficult.setText("Hard Puzzle");
        jButtonDifficult.setToolTipText("Unique solution that will require guessing");
        jButtonDifficult.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonDifficultActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel1.add(jButtonDifficult, gridBagConstraints);

        jToggleButtonHints.setText("Hints");
        jToggleButtonHints.setToolTipText("Turns on/off hints");
        jToggleButtonHints.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToggleButtonHintsActionPerformed(evt);
            }
        });
        jPanel1.add(jToggleButtonHints, new java.awt.GridBagConstraints());

        add(jPanel1, java.awt.BorderLayout.LINE_END);

        jLabelStatus.setText("Sudoku Game -- click on location, type 1 through 9 or space to clear");
        add(jLabelStatus, java.awt.BorderLayout.PAGE_END);
    }// </editor-fold>//GEN-END:initComponents

    private void jToggleButtonLockedActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButtonLockedActionPerformed
        _f.lockArray(jToggleButtonLocked.isSelected());
        viewScreen.drawAll(_f);
    }//GEN-LAST:event_jToggleButtonLockedActionPerformed

    private void jButtonClearActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonClearActionPerformed
        _f = new Field();
        _f.calculatePossibles(); // initialize everything in the field
        jToggleButtonLocked.setSelected(false); // make it unlocked
        viewScreen.drawAll(_f);
    }//GEN-LAST:event_jButtonClearActionPerformed

    private void viewScreenKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_viewScreenKeyTyped
        char key = evt.getKeyChar();
        evt.consume();

        Point pt = viewScreen.getLogCursorPosition();
        int x = (int) pt.getX();
        int y = (int) pt.getY();
        int index = Field.coordinatesToIndex(x, y);

        if (!_f.isLocked(index)) { // Only do something if not locked
            if (key == ' ') { // Space erases value
                _f.squares[index] = 0;
            } else if (key >= '0' && key <= '9') { // 0-9 inserts/replaces value
                int val = (int) key - (int) '0';
                int saveSquare = _f.squares[index]; // Save anything at position
                _f.squares[index] = 0;
                _f.setMarks();
                _f.calculatePossibles();
                if ((_f.possibles[index] & (1 << (val - 1))) == 0) {
                    // invalid choice
                    _f.squares[index] = saveSquare; // revert to saved
                    _f.setMarks();
                    _f.calculatePossibles();
                    getToolkit().beep();
                    return; // Get outa here!
                }
                _f.squares[index] = val;
            } else { // Invalid key
                getToolkit().beep();
                return; // Get outa here!
            }
            viewScreen.putText(x, y, _f);
            _f.setMarks();
            GameState state = _f.getState();
            switch (state) {
                case FAIL:
                    jLabelStatus.setText("FAIL: no available moves");
                    break;
                case SUCCESS:
                    jLabelStatus.setText("SUCCESS!!!");
                    break;
                case IN_PROGRESS:
                    jLabelStatus.setText("Puzzle in progress");
                    break;
            }
        }

        // goto next coordinate
        int times = 0;
        do {
            if (times++ > Field.LOCATIONS) break; // Prevents lockup in diabolical case
            if (x < 8) {
                x++;
            } else {
                x = 0;
                if (y < 8) {
                    y++;
                } else {
                    y = 0;
                }
            }
        } while (_f.isLocked(Field.coordinatesToIndex(x, y)));
        viewScreen.setLogCursorPosition(x, y);
        if (jToggleButtonHints.isSelected()) {
            // We must redraw everything if we are hinting
            viewScreen.drawAll(_f);
        }

}//GEN-LAST:event_viewScreenKeyTyped

    private void jButtonPlayActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonPlayActionPerformed
        Field new_f = new Field(_f);
        if (!jToggleButtonLocked.isSelected()) {
            new_f.lockArray(true);
        }
        PlayEngine p = new PlayEngine(new_f);
        try {
            new_f = p.playUntilSolvedOrQuit();
        } catch (MultipleSolutionException ex) { // won't occur
        }
        if (new_f == null) {
            jLabelStatus.setText("No solution found");
        } else {
            jToggleButtonLocked.setSelected(true);
            jLabelStatus.setText("Computer Solution Found!!");
            _f = new_f;
            viewScreen.drawAll(_f);
        }
    }//GEN-LAST:event_jButtonPlayActionPerformed

    private void jButtonPlayNoRetryActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonPlayNoRetryActionPerformed
        Field new_f = new Field(_f);
        if (!jToggleButtonLocked.isSelected()) {
            new_f.lockArray(true);
        }
        PlayEngine p = new PlayEngine(new_f);
        p.setNoBacktrack();
        try {
            new_f = p.playUntilSolvedOrQuit();
        } catch (MultipleSolutionException ex) { // Won't occur
        }
        if (new_f == null) {
            jLabelStatus.setText("No solution possible");
        } else {
            GameState state = new_f.getState();
            switch (state) {
                case FAIL:
                    jLabelStatus.setText("FAIL: no available moves");
                    return;
                case SUCCESS:
                    jLabelStatus.setText("Computer solution found!!!");
                    break;
                case IN_PROGRESS:
                    jLabelStatus.setText("Puzzle in progress");
                    break;
            }
            jToggleButtonLocked.setSelected(true);
            _f = new_f;
            viewScreen.drawAll(_f);
        }
    }//GEN-LAST:event_jButtonPlayNoRetryActionPerformed

    private void jButtonValidateActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonValidateActionPerformed
        switch (PlayEngine.verify(_f)) {
            case NO_SOLUTION:
                jLabelStatus.setText("No solution possible");
                break;
            case EASY_SOLUTION:
                jLabelStatus.setText("Easy solution possible");
                break;
            case HARD_SOLUTION:
                jLabelStatus.setText("Hard solution possible");
                break;
        }

    }//GEN-LAST:event_jButtonValidateActionPerformed

    private void createEasyPuzzle() {
       // Create an easy puzzle
        _f = new Field();
        _f.calculatePossibles();
        PlayEngine p = new PlayEngine(_f);
        _f = p.playRandomlyUntilSolvedOrQuit(); // Now fully filled
        ArrayList <Integer> l = new ArrayList<Integer>();
        for (int i = 0; i < Field.LOCATIONS; i++) l.add(Integer.valueOf(i));
        java.util.Collections.shuffle(l, Chooser.getChooser().getRandom());
        for (int i : l) {
            Field new_f = new Field(_f);
            new_f.squares[i] = 0;
            new_f.setMarks();
            p = new PlayEngine(new_f);
            p.setNoBacktrack();
            try {
                new_f = p.playUntilSolvedOrQuit();
            } catch (MultipleSolutionException ex) {
            }
            if (new_f.getState() == GameState.SUCCESS) {
                // OK to remove
                _f.squares[i] = 0;
                _f.setMarks();
            }
        }
        _f.calculatePossibles();

    }

    private void jButtonCreateActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCreateActionPerformed
        createEasyPuzzle();
        jToggleButtonLocked.setSelected(true);
        _f.lockArray(true);
        viewScreen.drawAll(_f);
        jLabelStatus.setText("Easy puzzle created, "+ _f.hints() + " hints.");
    }//GEN-LAST:event_jButtonCreateActionPerformed

    private void jButtonDifficultActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonDifficultActionPerformed
        createEasyPuzzle();
        ArrayList <Integer> l = new ArrayList<Integer>();
        for (int i = 0; i < Field.LOCATIONS; i++) {
            if (_f.squares[i] != 0) l.add(Integer.valueOf(i));
        }
        java.util.Collections.shuffle(l, Chooser.getChooser().getRandom());
        for (int i : l) {
            Field new_f = new Field(_f);
            new_f.squares[i] = 0;
            new_f.setMarks();
            PlayEngine p = new PlayEngine(new_f);
            p.setCheckMultiples(true);
            try {
                new_f = p.playUntilSolvedOrQuit();
                if (new_f != null) {
                    // Unique solution so OK to remove
                    _f.squares[i] = 0;
                    _f.setMarks();
                }
            } catch (MultipleSolutionException ex) {
            }
       }

        jToggleButtonLocked.setSelected(true);
        _f.lockArray(true);
        viewScreen.drawAll(_f);
        jLabelStatus.setText("Hard but unique puzzle created, "+ _f.hints() + " hints.");

    }//GEN-LAST:event_jButtonDifficultActionPerformed

    private void jToggleButtonHintsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButtonHintsActionPerformed
        viewScreen.setHinting(jToggleButtonHints.isSelected());
        viewScreen.drawAll(_f);
        if (jToggleButtonHints.isSelected()) {
            // If turned on, give instructions
            jLabelStatus.setText("Green: one choice, Yellow: two choices");
        }
    }//GEN-LAST:event_jToggleButtonHintsActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonClear;
    private javax.swing.JButton jButtonCreate;
    private javax.swing.JButton jButtonDifficult;
    private javax.swing.JButton jButtonPlay;
    private javax.swing.JButton jButtonPlayNoRetry;
    private javax.swing.JButton jButtonValidate;
    private javax.swing.JLabel jLabelStatus;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JToggleButton jToggleButtonHints;
    private javax.swing.JToggleButton jToggleButtonLocked;
    private sudoku.ViewScreen viewScreen;
    // End of variables declaration//GEN-END:variables
}
