/* prepare dictionary files for jumble */
/* Written by Tom Almy  10/89 */

/* Compile with "Small" model -- small code, large data */
/* Tested with Turbo-C 2.0 and Microsoft C 5.0 */


/* Input file should be dictionary that has plural forms, at minimum. */
/* The dictionary file from MKS Toolkit does just fine. */

#include <stdio.h>
#include <string.h>
#include <ctype.h>


FILE *infile, *out[11];

void error(char *s)
{
	fprintf(stderr,"%s",s);
	exit(1);
}

void initialize(char **argv, int argc)
{
	if (argc != 2) { /* bad news */
		fprintf(stderr,"Preparation program for JUMBLE\nUsage: prepare dictionaryname\n");
		exit(0);
	}
	if ((out[2] = fopen("size2.dic","w")) == NULL ||
		(out[3] = fopen("size3.dic","w")) == NULL ||
		(out[4] = fopen("size4.dic","w")) == NULL ||
		(out[5] = fopen("size5.dic","w")) == NULL ||
		(out[6] = fopen("size6.dic","w")) == NULL ||
		(out[7] = fopen("size7.dic","w")) == NULL ||
		(out[8] = fopen("size8.dic","w")) == NULL ||
		(out[9] = fopen("size9.dic","w")) == NULL ||
		(out[10] = fopen("size10.dic","w")) == NULL) {
		error("prepare: unable to create all output files.");
	}
	if ((infile = fopen(argv[1],"r")) == NULL) {
	    fprintf(stderr, "prepare: dictionary file %s  not found.", argv[1]);
	    exit(1);
	}
}

struct datastruct {
	int tag;
	char string[100];
};


void process()
{
    struct datastruct data;
    char buf[256];
    int len,i;
    while (fgets(buf,256,infile) != NULL) {
	strcpy(data.string, buf);
	len = strlen(data.string) - 1;	/* ignore \n character */
	if (len >= 2 && len <= 10) {/* only care about 2-10 character words */
	    for (i=0, data.tag=0; i < len; i++) {
		if (islower(data.string[i]) == 0){
		    goto next; /* SORRY! */
		}
		data.tag += data.string[i] - 'a';
	    }
	    if (fwrite(&data,sizeof(int)+len,1,out[len]) != 1) {
		error("prepare: disk full, cannot prepare.");
	    }
	}
next:;
    }
}




void main(int argc, char **argv)
{
    initialize(argv, argc);
    process();
}
