/* Wordsin -- find words hidden in a word*/
/* Written by Tom Almy  10/89 */
/* Public Domain */


/* Compile with "Compact" model -- small code, large data */
/* Tested with Turbo-C 2.0 and Microsoft C 5.0 (which is faster) */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <fcntl.h>
#define min(a,b) ((a)<(b) ? (a) : (b))

struct datastruct {
	int tag;
	char string[100];
};

static int currentFile = 0;

static char *FILES[] = {"","","size2.dic","size3.dic","size4.dic",
"size5.dic","size6.dic","size7.dic","size8.dic","size9.dic","size10.dic"};

static int recordSize = 0;	/* size of record in file */
static int recsPerBuf = 0;	/* number of records per buffer */
static int recsInLastBuf = 0;
static int recsInThisBuf = 0;
static int curRec = 0;		/* current record number */
static int lastBuf = 0;		/* last buffer */
static int curBuf = 0;		/* current buffer number */
static struct datastruct *wordBufs[20];

void initialize(int i)
{
	int infile;

	if (currentFile == i) {
		curBuf = 0;
		curRec = 0;
		recsInThisBuf = (curBuf == lastBuf ? recsInLastBuf : recsPerBuf);
		return;
	}
	if (currentFile != 0) { /* free used memory */
		for (curBuf =0; curBuf <= lastBuf; curBuf++)
			free(wordBufs[curBuf]);
	}

	currentFile = i;
	if ((infile=open(FILES[i],O_RDONLY)) == 0) {
		fprintf(stderr, "ERROR: file %s not found");
		exit(1);
	}
	recordSize = sizeof(int)+i;
	recsInThisBuf = 32767 / recordSize;
	recsPerBuf = recsInThisBuf;
	lastBuf = curBuf = curRec = 0;
	while (1) {
		if ((wordBufs[lastBuf] = malloc(recordSize*recsPerBuf)) == NULL) {
			fprintf(stderr,"Insufficient memory");
			exit(1);
		}
		recsInLastBuf = ((unsigned int)read(infile,
			wordBufs[lastBuf],recordSize*recsPerBuf))/recordSize;
		if (recsInLastBuf == 0) { /* one too many buffers */
			free(wordBufs[lastBuf--]);
			recsInLastBuf = recsPerBuf;
			break;
		}
		if (recsInLastBuf < recsPerBuf) break;
		lastBuf++;
	}
	close(infile);
	if (lastBuf == 0) recsInThisBuf = recsInLastBuf;
}

static struct datastruct *data;
	
static int searchStat[26];
static int searchLen,recLen;
static int searchValue;

setSearchFromStat(int *srchbuf, int size)
{
	int i;
	searchLen = size;
	recLen = size + sizeof(int);
	memcpy(searchStat,srchbuf,sizeof(searchStat));

	for (searchValue = 0, i = 0; i < 26; i++) 
		searchValue += searchStat[i]*i;

	initialize(size);
	return (0);
}


char *doSearch() /* search for matching string */
{
	int thisStat[26];
	int i;
	while (1) {

		if (recsInThisBuf == curRec) { /* go to next buffer */
			curRec = 0;
			curBuf++;
			if (curBuf > lastBuf) return NULL;
			if (curBuf == lastBuf) recsInThisBuf = recsInLastBuf;
		}
		data = (struct datastruct *)(((long)wordBufs[curBuf])+recordSize*curRec);
		curRec++;
		
		if (searchValue == data->tag) {
			memcpy(thisStat,searchStat,sizeof(thisStat));
			for (i=0; i<searchLen; i++) 
				if (--thisStat[data->string[i]-'a'] < 0) goto thisFail;
			return data->string;
		}
		thisFail:;
	}
	return NULL;
}

static int ourStat[26];
static int ourInitStat[26];
static int complete;
static int maxcnt;

void domessy(int cnt, int start)
{
	int i;
	int j;
	int ii;
	char *s;

	for (i = start; i < 26; i++) {
		if (ourStat[i] != 0) {
			ourStat[i]--;
			if (cnt == 1) { /* process it now! */
				setSearchFromStat(ourStat,maxcnt);
				while ((s=doSearch()) != NULL) 	printf("%.*s\n",maxcnt,s);
			}
			else { /* must recurse */
				domessy(cnt-1,i);
			}
			ourStat[i]++;
		}
	}
}

void wordsin(char *s)
{
	int len = strlen(s);
	int truelen = len;
	int j;
	char *ptr;

	if (len <= 2) {	/* dumb case */
		fprintf(stderr,"word must be at least three characters long");
		exit(1);
	}

	memset(ourStat,0,sizeof(ourStat));
	for (j= 0; j < len; j++) {
		if (islower(s[j]) == 0) {
			fprintf(stderr,"%s is invalid string for jumble");
			exit(1);
		}
		ourStat[s[j]-'a'] += 1;
	}

	len = min(len,10);

	memcpy(ourInitStat,ourStat,sizeof(ourStat));

	for (j=truelen-len; j < truelen-1; j++) {
		maxcnt = truelen - j;
		domessy(j,0);
	}

}


void main(int argc, char **argv)
{
	char *ptr;
	int count;
	
	if (argc != 2) {
		fprintf(stderr,"Wordsin program\nUsage: wordsin word\n");
		exit(1);
	}

	wordsin(argv[1]);


}
