/* Jelbum -- Jumble (tm) Puzzle Solver */
/* Written by Tom Almy  10/89 */
/* Public Domain */

/* Compile with "Small" model -- small code, large data */
/* Tested with Turbo-C 2.0 and Microsoft C 5.0 (which is faster) */

/* use this version if dictionary files are too big for other version */
/* performance will be much slower unless disk caching is used */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>

struct datastruct {
	int tag;
	char string[100];
};

struct linkeddata {
	int tag;
	struct linkeddata *next;
    int thisStat[26];
	char string[1];
};

static FILE *infile = NULL;
static int currentFile = 0;

static char *FILES[] = {"","","size2.dic","size3.dic","size4.dic",
"size5.dic","size6.dic","size7.dic","size8.dic"};


void initialize(int i)
{
	if (currentFile == i) {
		rewind(infile);
		return;
	}
	currentFile = i;
	if (infile != NULL) fclose(infile);
	if ((infile=fopen(FILES[i],"rb")) == NULL) {
		fprintf(stderr, "ERROR: file %s not found");
		exit(1);
	}
	if (setvbuf(infile, NULL, _IOFBF, 0x7000)) {
		fprintf(stderr, "Buffering failed, continuing\n");
	}
}

static struct datastruct data;
	
static int searchStat[26];
static int searchLen,recLen;
static int searchValue;

setSearchFromStat(int *srchbuf, int size)
{
	int i;
	searchLen = size;
	recLen = size + sizeof(int);
    data.string[searchLen] = 0;
	memcpy(searchStat,srchbuf,sizeof(searchStat));

	for (searchValue = 0, i = 0; i < 26; i++) 
		searchValue += searchStat[i]*i;

	initialize(size);
	return (0);
}


int setSearch(char *s)	/* return non-zero if arg string is bad */
{
	int i,c;
	searchLen = strlen(s);
	recLen = searchLen + sizeof(int);
    data.string[searchLen] = 0;
	if (searchLen < 2 || searchLen > 8) return (1);
	memset(searchStat,0,sizeof(searchStat));
	for (searchValue = 0, i = 0; i < searchLen; i++) {
		if (islower(s[i]) == 0) return(1);
		c = s[i] - 'a';
		searchValue += c;
		searchStat[c] += 1;
	};
	initialize(searchLen);
	return (0);
}
		


char *doSearch() /* search for matching string */
{
	int thisStat[26];
	int i;

	while (fread(&data,recLen,1,infile) == 1) {
		if (searchValue == data.tag) {
			memcpy(thisStat,searchStat,sizeof(thisStat));
			for (i=0; i<searchLen; i++) 
				if (--thisStat[data.string[i]-'a'] < 0) goto thisFail;
			return data.string;
		}
		thisFail:;
	}
	return NULL;
}


void simplejumble(char *s)
{
	char *ptr;
	if (setSearch(s)) {
		fprintf(stderr,"%s is an invalid string for Jumble",s);
		exit(1);
	}
	while ((ptr = doSearch()) != NULL) {
		printf("%s\n",ptr);
	}
}

static int ourStat[26];
static int ourInitStat[26];
static int maxcnt;
static int complete;
static struct linkeddata *datalist;
static int passnum;

void domessy(int cnt, int start)
{
	int i;
	int j;
	int ii;
	char *s;
	struct linkeddata *n;

	for (i = start; i < 26; i++) {
		if (ourStat[i] != 0) {
			ourStat[i]--;
			if (cnt == 1) { /* process it now! */
				setSearchFromStat(ourStat,maxcnt);
				if (complete) {
					fprintf(stderr,"Pass %d\r", passnum++);
				}
				while ((s=doSearch()) != NULL) {
					if (complete) {
						n = malloc(sizeof(struct linkeddata)+maxcnt);
						n->tag = data.tag;
						strcpy(n->string,data.string);
						for (j = 0; j< 26; j++) {
							n->thisStat[j] = ourInitStat[j] - ourStat[j];
						}
						n->next = datalist;
						datalist = n;
					}
					else {
						printf("%s with:",s);
						for (j = 0; j < 26; j++) {
							ii = ourInitStat[j] - ourStat[j];
							while (ii-- > 0) printf("%c ",j+'a');
						}
						printf("\n");
					}
				}
			}
			else { /* must recurse */
				domessy(cnt-1,i);
			}
			ourStat[i]++;
		}
	}
}

void messyjumble(char *s, int i)
{
	int len = strlen(s);
	int j;
	char *ptr;
	static struct linkeddata *dl;

	datalist = NULL;

	if (i < 0) {	/* run to completion */
		complete = 1;
		i = -i;
	}
	else complete = 0;
	
	maxcnt = i;
	
	if (i < 2 || i > 8 || i >= len) {
		fprintf(stderr,"count value out of range");
		exit(1);
	}
	
	memset(ourStat,0,sizeof(ourStat));
	for (j= 0; j < len; j++) {
		if (islower(s[j]) == 0) {
			fprintf(stderr,"%s is invalid string for jumble");
			exit(1);
		}
		ourStat[s[j]-'a'] += 1;
	}

	memcpy(ourInitStat,ourStat,sizeof(ourStat));

	passnum = 1;		/* give user some feedback */
	domessy(len-i, 0);

	if (complete) {
		j = 0;
		dl = datalist;
		while (dl != NULL) {
			j++;
			dl = dl->next;
		}
		if (j == 0) {
			fprintf(stderr,"\nNo matches found\n");
			return;
		}
		
		fprintf(stderr,
			"\n%d matches found\nNow searching for second words...\n",j);
		while (datalist != NULL) {
			setSearchFromStat(datalist->thisStat, len-i);
			while ((ptr = doSearch()) != NULL) {
				printf("%s %s\n",datalist->string, ptr);
			}
			datalist = datalist->next;
		}
	}
			

}


void main(int argc, char **argv)
{
	char *ptr;
	int count;
	
	if (argc < 2 || argc > 3) {
		fprintf(stderr,"Jumble program\nUsage: jumble word\n or jumble word count");
		exit(1);
	}

	if (argc == 2) simplejumble(argv[1]);
	else messyjumble(argv[1],atoi(argv[2]));


}
