/* PROCESSI -- A program to process the Frontdoor or InterMail log files
   to update the download counters in Remote Acess 2.00 */

/*
			 Author: Thomas Almy
          Fidonet Address: 1:105/290
       Internet Address: tom.almy@tek.com

This program Copyright 1993 by Thomas Almy. Permission is given to
Registered users of RemoteAccess to use this program. Permission is
given to distribute this program, providing it is not altered.
*/

/* compile using Borland C with flags: -b- -mc */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <dos.h>
#include "ra200.h"

FILE *fhp = NULL;	/* pointer to files.ra (FILES structure type) */
char filebasepath[61];	/* root directory of filebase */
char filename[128]; /* file name to hunt for */
char filedir[128];	/* directory of file to hunt for */
long datestamp;     /* datestamp to use */

typedef struct ignorelist {
	struct ignorelist *next;
	char *text;
	int textlen;
} IGNORE;

IGNORE *igl = NULL;
	

extern unsigned _stklen = 12000;

void died(char *s) {
	printf("ERROR: %s\n", s);
	exit(1);
}

void getignore(char *s) {
	FILE *fp;
	char buf[128];
	IGNORE *new;

	if ((fp=fopen(s, "rt")) == NULL) died("Ignore list file not found");
	while (fscanf(fp,"%128s", buf) == 1) {
		/* read a character sequence */
		new = (IGNORE *)malloc(sizeof(IGNORE));
		if (new == NULL)
			died("Not enough memory to process ignore list");
		new->next = igl;
		igl = new;
		new->textlen = strlen(buf);
		new->text = (char *)malloc(new->textlen + 1);
		if (new->text == NULL)
			died("Not enough memory to process ignore list");
		strcpy(new->text, buf);
	}
	fclose(fp);
}
		
		
void getdirs(void) {
	CONFIG config;
	char tmpbuf[128];
	char tmpbuf2[128];
	char *raenv;
	struct date datep;
	FILE *fp;
	
	/* get the directories of the file base */
	raenv = getenv("RA");
	if (raenv == NULL) died("RA environment variable missing");
	strcpy(tmpbuf, raenv);
	if (tmpbuf[strlen(tmpbuf)-1] != '\\') strcat(tmpbuf, "\\");
	strcpy(tmpbuf2, tmpbuf);
	strcat(tmpbuf, "config.ra");
	fp = fopen(tmpbuf, "rb");	/* we won't file share since this program
								   should only be run at maintenance time */
	if (fp==NULL) died("could not open config.ra");
	if (fread(&config, sizeof(CONFIG), 1, fp) != 1)
		died("could not read config.ra");
	memcpy(filebasepath, config.FileBasePath, config.l47);
	filebasepath[config.l47] = 0;
	fclose(fp);

	strcat(tmpbuf2, "files.ra");
	fhp = fopen(tmpbuf2, "rb");
	if (fhp==NULL) died("could not open files.ra");
	setvbuf(fhp, NULL, _IOFBF, sizeof(FILES)*100);

	/* get todays date to use for download datestamp */
	getdate(&datep);
	datestamp = (datep.da_year-1980) * 0x2000000L +
				datep.da_mon         *  0x200000L +
				datep.da_day         *   0x10000L;
}

void seekout(void) {
	int filedirlen = strlen(filedir);
	int filenamelen = strlen(filename);
	FILES files;
	FILESHDR filehdr;
	char tempstr[128];
	static char lastfname[128];
	int indx = 0;
	static FILE *fdhp = NULL;

	rewind(fhp);
	while (fread(&files, sizeof(FILES), 1, fhp) == 1) {
		indx++;
		/* check this entry */
		if (files.l2 == filedirlen &&
			strncmp(filedir, files.filepath, files.l2) == 0) {
			/* got the right directory, now open the file dir header */
			sprintf(tempstr, "%shdr\\fdb%d.hdr", filebasepath, indx);
			/* save some work if already open */
			if (fdhp == NULL || strcmp(tempstr, lastfname) != 0) {
				/* we need to open a new file */
				if (fdhp != NULL) fclose(fdhp);
				fdhp = fopen(tempstr, "r+b");	/* need to write this one */
				if (fdhp == NULL) died(strcat(tempstr, " not found"));
				setvbuf(fdhp, NULL, _IOFBF, sizeof(FILESHDR)*50);
				strcpy(lastfname, tempstr);
			}
			else {
				/* rewind already open file */
				rewind(fdhp);
			}
			/* search the fdb*.hdr file */
			while (fread(&filehdr, sizeof(FILESHDR), 1, fdhp) == 1) {
				if (filenamelen == filehdr.l1 &&
					strncmp(filename, filehdr.name, filehdr.l1) == 0) {
					/* got it! */
					filehdr.timesdl++;
					filehdr.lastdl = datestamp;
					printf("Updating count of %s in %s to %u\n",
						   filename, filedir, filehdr.timesdl);
					fseek(fdhp, -(long)(sizeof(FILESHDR)), SEEK_CUR);
					fwrite(&filehdr, sizeof(FILESHDR), 1, fdhp);
					return;
				}
			}
			printf("File %s in %s not listed\n", filename, filedir);
			return;
		}
	}
	/* directory not found */
	printf("Directory %s not found in filebase.\n", filedir);
}
	
void main(int argc, char **argv) {
	char *cp;
	FILE *fp;
	int matchlen;
	long pos;
	int i;
	IGNORE *this;
	char linebuf[256];	

	fprintf(stderr,"PROCESSI--FREQ download counter updater\n"
				   "Copyright 1993 by Thomas Almy\n");

	if (argc < 2 || argc > 3) {
		fprintf(stderr, "Usage: processi logfilename [ignorefilename]\n");
		exit(1);
	}

	if (argc == 3) getignore(argv[2]);

	getdirs();

	if ((fp = fopen(argv[1], "rt")) == NULL)
		died("Log file not found");

	/* read each line of log file, searching for a FREQ file to check */
	while (fgets(linebuf, 256, fp) != NULL) {
		/* valid FREQ lines have "Sent" at index 12 */
		if (strncmp(&linebuf[12], "Sent", 4) != 0) continue;

		/* trap out directories we are not interested in */
		for (this = igl; this != NULL; this = this->next)
			if (strncmp(&linebuf[17], this->text, this->textlen) == 0) break;

		if (this != NULL) /* we aren't interested! */
			continue;

		/* got a good line! */

		linebuf[strlen(linebuf)-1] = 0;  /* toss trailing newline char */

		cp = strchr(&linebuf[17],';');	/* delimit string at any semicolon */
		if (cp != NULL) *cp = 0;

		cp = strrchr(&linebuf[17], '\\'); /* last separator */
		strcpy(filename, cp+1);
		*cp = 0;
		/* directory path w.o. trailing backslash */
		strcpy(filedir, &linebuf[17]);
		/* process the line */
		seekout();	
	}
}
