(require "factor")
(unless (find-package "EULER")
        (make-package "EULER" :use '("XLISP" "FACTOR")))
(use-package "EULER")
(in-package "EULER")
(export '(euler41 euler42 euler43 euler44 euler45
                  euler45a euler45b euler46
                  euler47 euler48 euler49 euler50 euler50a))
(require "fact")

; From problem 24, with modifications:

(defun
 euler41
 (n)
 (flet ((make-factorials (n)
			 (let (result)
			      (dotimes (i n)
				       (push (fact i) result))
			      result))
	(make-digits (n)
		     (let (result)
			  (do ((i n (1- i)))
			      ((zerop i))
			      (push i result))
			  (nreverse result)))
	(to-factoradic (n factorials)
		       (mapcar #'(lambda (f)
					 (let ((result (floor n f)))
					      (decf n (* result f))
					      result))
			       factorials))

	(permute (factoridic choices)
		 (mapcar #'(lambda (digit) (let ((result (nth digit choices)))
						(setf choices (remove result choices))
						result))
			 factoridic)))
       ; body of euler41 code
       (let ((factorials (make-factorials n))
	     (digits (make-digits n)))
	    (do ((i 0 (1+ i)))
		((let* ((val (permute (to-factoradic i factorials) digits))
			(valstring (coerce (mapcar #'(lambda (x) (int-char (+ x 48)))
						   val)
					   'string))
			(valnum (read-from-string valstring)))
		       (when (primep valnum)
			     (format t "Result is = ~s\n" valnum)
			     t)))))))

; Ugly. I missed that n=9 and n=8 can't be solutions. Program errors out with those
; arguments. Sorry. But I've improved my style here by using flet
			      
(defconstant +words+ '("A" "ABILITY" "ABLE" "ABOUT" "ABOVE" "ABSENCE" "ABSOLUTELY" "ACADEMIC"
"ACCEPT" "ACCESS" "ACCIDENT" "ACCOMPANY" "ACCORDING" "ACCOUNT"
"ACHIEVE" "ACHIEVEMENT" "ACID" "ACQUIRE" "ACROSS" "ACT" "ACTION"
"ACTIVE" "ACTIVITY" "ACTUAL" "ACTUALLY" "ADD" "ADDITION" "ADDITIONAL"
"ADDRESS" "ADMINISTRATION" "ADMIT" "ADOPT" "ADULT" "ADVANCE"
"ADVANTAGE" "ADVICE" "ADVISE" "AFFAIR" "AFFECT" "AFFORD" "AFRAID"
"AFTER" "AFTERNOON" "AFTERWARDS" "AGAIN" "AGAINST" "AGE" "AGENCY"
"AGENT" "AGO" "AGREE" "AGREEMENT" "AHEAD" "AID" "AIM" "AIR" "AIRCRAFT"
"ALL" "ALLOW" "ALMOST" "ALONE" "ALONG" "ALREADY" "ALRIGHT" "ALSO"
"ALTERNATIVE" "ALTHOUGH" "ALWAYS" "AMONG" "AMONGST" "AMOUNT" "AN"
"ANALYSIS" "ANCIENT" "AND" "ANIMAL" "ANNOUNCE" "ANNUAL" "ANOTHER"
"ANSWER" "ANY" "ANYBODY" "ANYONE" "ANYTHING" "ANYWAY" "APART"
"APPARENT" "APPARENTLY" "APPEAL" "APPEAR" "APPEARANCE" "APPLICATION"
"APPLY" "APPOINT" "APPOINTMENT" "APPROACH" "APPROPRIATE" "APPROVE"
"AREA" "ARGUE" "ARGUMENT" "ARISE" "ARM" "ARMY" "AROUND" "ARRANGE"
"ARRANGEMENT" "ARRIVE" "ART" "ARTICLE" "ARTIST" "AS" "ASK" "ASPECT"
"ASSEMBLY" "ASSESS" "ASSESSMENT" "ASSET" "ASSOCIATE" "ASSOCIATION"
"ASSUME" "ASSUMPTION" "AT" "ATMOSPHERE" "ATTACH" "ATTACK" "ATTEMPT"
"ATTEND" "ATTENTION" "ATTITUDE" "ATTRACT" "ATTRACTIVE" "AUDIENCE"
"AUTHOR" "AUTHORITY" "AVAILABLE" "AVERAGE" "AVOID" "AWARD" "AWARE"
"AWAY" "AYE" "BABY" "BACK" "BACKGROUND" "BAD" "BAG" "BALANCE" "BALL"
"BAND" "BANK" "BAR" "BASE" "BASIC" "BASIS" "BATTLE" "BE" "BEAR" "BEAT"
"BEAUTIFUL" "BECAUSE" "BECOME" "BED" "BEDROOM" "BEFORE" "BEGIN"
"BEGINNING" "BEHAVIOUR" "BEHIND" "BELIEF" "BELIEVE" "BELONG" "BELOW"
"BENEATH" "BENEFIT" "BESIDE" "BEST" "BETTER" "BETWEEN" "BEYOND" "BIG"
"BILL" "BIND" "BIRD" "BIRTH" "BIT" "BLACK" "BLOCK" "BLOOD" "BLOODY"
"BLOW" "BLUE" "BOARD" "BOAT" "BODY" "BONE" "BOOK" "BORDER" "BOTH"
"BOTTLE" "BOTTOM" "BOX" "BOY" "BRAIN" "BRANCH" "BREAK" "BREATH"
"BRIDGE" "BRIEF" "BRIGHT" "BRING" "BROAD" "BROTHER" "BUDGET" "BUILD"
"BUILDING" "BURN" "BUS" "BUSINESS" "BUSY" "BUT" "BUY" "BY" "CABINET"
"CALL" "CAMPAIGN" "CAN" "CANDIDATE" "CAPABLE" "CAPACITY" "CAPITAL"
"CAR" "CARD" "CARE" "CAREER" "CAREFUL" "CAREFULLY" "CARRY" "CASE"
"CASH" "CAT" "CATCH" "CATEGORY" "CAUSE" "CELL" "CENTRAL" "CENTRE"
"CENTURY" "CERTAIN" "CERTAINLY" "CHAIN" "CHAIR" "CHAIRMAN" "CHALLENGE"
"CHANCE" "CHANGE" "CHANNEL" "CHAPTER" "CHARACTER" "CHARACTERISTIC"
"CHARGE" "CHEAP" "CHECK" "CHEMICAL" "CHIEF" "CHILD" "CHOICE" "CHOOSE"
"CHURCH" "CIRCLE" "CIRCUMSTANCE" "CITIZEN" "CITY" "CIVIL" "CLAIM"
"CLASS" "CLEAN" "CLEAR" "CLEARLY" "CLIENT" "CLIMB" "CLOSE" "CLOSELY"
"CLOTHES" "CLUB" "COAL" "CODE" "COFFEE" "COLD" "COLLEAGUE" "COLLECT"
"COLLECTION" "COLLEGE" "COLOUR" "COMBINATION" "COMBINE" "COME"
"COMMENT" "COMMERCIAL" "COMMISSION" "COMMIT" "COMMITMENT" "COMMITTEE"
"COMMON" "COMMUNICATION" "COMMUNITY" "COMPANY" "COMPARE" "COMPARISON"
"COMPETITION" "COMPLETE" "COMPLETELY" "COMPLEX" "COMPONENT" "COMPUTER"
"CONCENTRATE" "CONCENTRATION" "CONCEPT" "CONCERN" "CONCERNED"
"CONCLUDE" "CONCLUSION" "CONDITION" "CONDUCT" "CONFERENCE"
"CONFIDENCE" "CONFIRM" "CONFLICT" "CONGRESS" "CONNECT" "CONNECTION"
"CONSEQUENCE" "CONSERVATIVE" "CONSIDER" "CONSIDERABLE" "CONSIDERATION"
"CONSIST" "CONSTANT" "CONSTRUCTION" "CONSUMER" "CONTACT" "CONTAIN"
"CONTENT" "CONTEXT" "CONTINUE" "CONTRACT" "CONTRAST" "CONTRIBUTE"
"CONTRIBUTION" "CONTROL" "CONVENTION" "CONVERSATION" "COPY" "CORNER"
"CORPORATE" "CORRECT" "COS" "COST" "COULD" "COUNCIL" "COUNT" "COUNTRY"
"COUNTY" "COUPLE" "COURSE" "COURT" "COVER" "CREATE" "CREATION"
"CREDIT" "CRIME" "CRIMINAL" "CRISIS" "CRITERION" "CRITICAL"
"CRITICISM" "CROSS" "CROWD" "CRY" "CULTURAL" "CULTURE" "CUP" "CURRENT"
"CURRENTLY" "CURRICULUM" "CUSTOMER" "CUT" "DAMAGE" "DANGER"
"DANGEROUS" "DARK" "DATA" "DATE" "DAUGHTER" "DAY" "DEAD" "DEAL"
"DEATH" "DEBATE" "DEBT" "DECADE" "DECIDE" "DECISION" "DECLARE" "DEEP"
"DEFENCE" "DEFENDANT" "DEFINE" "DEFINITION" "DEGREE" "DELIVER"
"DEMAND" "DEMOCRATIC" "DEMONSTRATE" "DENY" "DEPARTMENT" "DEPEND"
"DEPUTY" "DERIVE" "DESCRIBE" "DESCRIPTION" "DESIGN" "DESIRE" "DESK"
"DESPITE" "DESTROY" "DETAIL" "DETAILED" "DETERMINE" "DEVELOP"
"DEVELOPMENT" "DEVICE" "DIE" "DIFFERENCE" "DIFFERENT" "DIFFICULT"
"DIFFICULTY" "DINNER" "DIRECT" "DIRECTION" "DIRECTLY" "DIRECTOR"
"DISAPPEAR" "DISCIPLINE" "DISCOVER" "DISCUSS" "DISCUSSION" "DISEASE"
"DISPLAY" "DISTANCE" "DISTINCTION" "DISTRIBUTION" "DISTRICT" "DIVIDE"
"DIVISION" "DO" "DOCTOR" "DOCUMENT" "DOG" "DOMESTIC" "DOOR" "DOUBLE"
"DOUBT" "DOWN" "DRAW" "DRAWING" "DREAM" "DRESS" "DRINK" "DRIVE"
"DRIVER" "DROP" "DRUG" "DRY" "DUE" "DURING" "DUTY" "EACH" "EAR"
"EARLY" "EARN" "EARTH" "EASILY" "EAST" "EASY" "EAT" "ECONOMIC"
"ECONOMY" "EDGE" "EDITOR" "EDUCATION" "EDUCATIONAL" "EFFECT"
"EFFECTIVE" "EFFECTIVELY" "EFFORT" "EGG" "EITHER" "ELDERLY" "ELECTION"
"ELEMENT" "ELSE" "ELSEWHERE" "EMERGE" "EMPHASIS" "EMPLOY" "EMPLOYEE"
"EMPLOYER" "EMPLOYMENT" "EMPTY" "ENABLE" "ENCOURAGE" "END" "ENEMY"
"ENERGY" "ENGINE" "ENGINEERING" "ENJOY" "ENOUGH" "ENSURE" "ENTER"
"ENTERPRISE" "ENTIRE" "ENTIRELY" "ENTITLE" "ENTRY" "ENVIRONMENT"
"ENVIRONMENTAL" "EQUAL" "EQUALLY" "EQUIPMENT" "ERROR" "ESCAPE"
"ESPECIALLY" "ESSENTIAL" "ESTABLISH" "ESTABLISHMENT" "ESTATE"
"ESTIMATE" "EVEN" "EVENING" "EVENT" "EVENTUALLY" "EVER" "EVERY"
"EVERYBODY" "EVERYONE" "EVERYTHING" "EVIDENCE" "EXACTLY" "EXAMINATION"
"EXAMINE" "EXAMPLE" "EXCELLENT" "EXCEPT" "EXCHANGE" "EXECUTIVE"
"EXERCISE" "EXHIBITION" "EXIST" "EXISTENCE" "EXISTING" "EXPECT"
"EXPECTATION" "EXPENDITURE" "EXPENSE" "EXPENSIVE" "EXPERIENCE"
"EXPERIMENT" "EXPERT" "EXPLAIN" "EXPLANATION" "EXPLORE" "EXPRESS"
"EXPRESSION" "EXTEND" "EXTENT" "EXTERNAL" "EXTRA" "EXTREMELY" "EYE"
"FACE" "FACILITY" "FACT" "FACTOR" "FACTORY" "FAIL" "FAILURE" "FAIR"
"FAIRLY" "FAITH" "FALL" "FAMILIAR" "FAMILY" "FAMOUS" "FAR" "FARM"
"FARMER" "FASHION" "FAST" "FATHER" "FAVOUR" "FEAR" "FEATURE" "FEE"
"FEEL" "FEELING" "FEMALE" "FEW" "FIELD" "FIGHT" "FIGURE" "FILE" "FILL"
"FILM" "FINAL" "FINALLY" "FINANCE" "FINANCIAL" "FIND" "FINDING" "FINE"
"FINGER" "FINISH" "FIRE" "FIRM" "FIRST" "FISH" "FIT" "FIX" "FLAT"
"FLIGHT" "FLOOR" "FLOW" "FLOWER" "FLY" "FOCUS" "FOLLOW" "FOLLOWING"
"FOOD" "FOOT" "FOOTBALL" "FOR" "FORCE" "FOREIGN" "FOREST" "FORGET"
"FORM" "FORMAL" "FORMER" "FORWARD" "FOUNDATION" "FREE" "FREEDOM"
"FREQUENTLY" "FRESH" "FRIEND" "FROM" "FRONT" "FRUIT" "FUEL" "FULL"
"FULLY" "FUNCTION" "FUND" "FUNNY" "FURTHER" "FUTURE" "GAIN" "GAME"
"GARDEN" "GAS" "GATE" "GATHER" "GENERAL" "GENERALLY" "GENERATE"
"GENERATION" "GENTLEMAN" "GET" "GIRL" "GIVE" "GLASS" "GO" "GOAL" "GOD"
"GOLD" "GOOD" "GOVERNMENT" "GRANT" "GREAT" "GREEN" "GREY" "GROUND"
"GROUP" "GROW" "GROWING" "GROWTH" "GUEST" "GUIDE" "GUN" "HAIR" "HALF"
"HALL" "HAND" "HANDLE" "HANG" "HAPPEN" "HAPPY" "HARD" "HARDLY" "HATE"
"HAVE" "HE" "HEAD" "HEALTH" "HEAR" "HEART" "HEAT" "HEAVY" "HELL"
"HELP" "HENCE" "HER" "HERE" "HERSELF" "HIDE" "HIGH" "HIGHLY" "HILL"
"HIM" "HIMSELF" "HIS" "HISTORICAL" "HISTORY" "HIT" "HOLD" "HOLE"
"HOLIDAY" "HOME" "HOPE" "HORSE" "HOSPITAL" "HOT" "HOTEL" "HOUR"
"HOUSE" "HOUSEHOLD" "HOUSING" "HOW" "HOWEVER" "HUGE" "HUMAN" "HURT"
"HUSBAND" "I" "IDEA" "IDENTIFY" "IF" "IGNORE" "ILLUSTRATE" "IMAGE"
"IMAGINE" "IMMEDIATE" "IMMEDIATELY" "IMPACT" "IMPLICATION" "IMPLY"
"IMPORTANCE" "IMPORTANT" "IMPOSE" "IMPOSSIBLE" "IMPRESSION" "IMPROVE"
"IMPROVEMENT" "IN" "INCIDENT" "INCLUDE" "INCLUDING" "INCOME"
"INCREASE" "INCREASED" "INCREASINGLY" "INDEED" "INDEPENDENT" "INDEX"
"INDICATE" "INDIVIDUAL" "INDUSTRIAL" "INDUSTRY" "INFLUENCE" "INFORM"
"INFORMATION" "INITIAL" "INITIATIVE" "INJURY" "INSIDE" "INSIST"
"INSTANCE" "INSTEAD" "INSTITUTE" "INSTITUTION" "INSTRUCTION"
"INSTRUMENT" "INSURANCE" "INTEND" "INTENTION" "INTEREST" "INTERESTED"
"INTERESTING" "INTERNAL" "INTERNATIONAL" "INTERPRETATION" "INTERVIEW"
"INTO" "INTRODUCE" "INTRODUCTION" "INVESTIGATE" "INVESTIGATION"
"INVESTMENT" "INVITE" "INVOLVE" "IRON" "IS" "ISLAND" "ISSUE" "IT"
"ITEM" "ITS" "ITSELF" "JOB" "JOIN" "JOINT" "JOURNEY" "JUDGE" "JUMP"
"JUST" "JUSTICE" "KEEP" "KEY" "KID" "KILL" "KIND" "KING" "KITCHEN"
"KNEE" "KNOW" "KNOWLEDGE" "LABOUR" "LACK" "LADY" "LAND" "LANGUAGE"
"LARGE" "LARGELY" "LAST" "LATE" "LATER" "LATTER" "LAUGH" "LAUNCH"
"LAW" "LAWYER" "LAY" "LEAD" "LEADER" "LEADERSHIP" "LEADING" "LEAF"
"LEAGUE" "LEAN" "LEARN" "LEAST" "LEAVE" "LEFT" "LEG" "LEGAL"
"LEGISLATION" "LENGTH" "LESS" "LET" "LETTER" "LEVEL" "LIABILITY"
"LIBERAL" "LIBRARY" "LIE" "LIFE" "LIFT" "LIGHT" "LIKE" "LIKELY"
"LIMIT" "LIMITED" "LINE" "LINK" "LIP" "LIST" "LISTEN" "LITERATURE"
"LITTLE" "LIVE" "LIVING" "LOAN" "LOCAL" "LOCATION" "LONG" "LOOK"
"LORD" "LOSE" "LOSS" "LOT" "LOVE" "LOVELY" "LOW" "LUNCH" "MACHINE"
"MAGAZINE" "MAIN" "MAINLY" "MAINTAIN" "MAJOR" "MAJORITY" "MAKE" "MALE"
"MAN" "MANAGE" "MANAGEMENT" "MANAGER" "MANNER" "MANY" "MAP" "MARK"
"MARKET" "MARRIAGE" "MARRIED" "MARRY" "MASS" "MASTER" "MATCH"
"MATERIAL" "MATTER" "MAY" "MAYBE" "ME" "MEAL" "MEAN" "MEANING" "MEANS"
"MEANWHILE" "MEASURE" "MECHANISM" "MEDIA" "MEDICAL" "MEET" "MEETING"
"MEMBER" "MEMBERSHIP" "MEMORY" "MENTAL" "MENTION" "MERELY" "MESSAGE"
"METAL" "METHOD" "MIDDLE" "MIGHT" "MILE" "MILITARY" "MILK" "MIND"
"MINE" "MINISTER" "MINISTRY" "MINUTE" "MISS" "MISTAKE" "MODEL"
"MODERN" "MODULE" "MOMENT" "MONEY" "MONTH" "MORE" "MORNING" "MOST"
"MOTHER" "MOTION" "MOTOR" "MOUNTAIN" "MOUTH" "MOVE" "MOVEMENT" "MUCH"
"MURDER" "MUSEUM" "MUSIC" "MUST" "MY" "MYSELF" "NAME" "NARROW"
"NATION" "NATIONAL" "NATURAL" "NATURE" "NEAR" "NEARLY" "NECESSARILY"
"NECESSARY" "NECK" "NEED" "NEGOTIATION" "NEIGHBOUR" "NEITHER"
"NETWORK" "NEVER" "NEVERTHELESS" "NEW" "NEWS" "NEWSPAPER" "NEXT"
"NICE" "NIGHT" "NO" "NOBODY" "NOD" "NOISE" "NONE" "NOR" "NORMAL"
"NORMALLY" "NORTH" "NORTHERN" "NOSE" "NOT" "NOTE" "NOTHING" "NOTICE"
"NOTION" "NOW" "NUCLEAR" "NUMBER" "NURSE" "OBJECT" "OBJECTIVE"
"OBSERVATION" "OBSERVE" "OBTAIN" "OBVIOUS" "OBVIOUSLY" "OCCASION"
"OCCUR" "ODD" "OF" "OFF" "OFFENCE" "OFFER" "OFFICE" "OFFICER"
"OFFICIAL" "OFTEN" "OIL" "OKAY" "OLD" "ON" "ONCE" "ONE" "ONLY" "ONTO"
"OPEN" "OPERATE" "OPERATION" "OPINION" "OPPORTUNITY" "OPPOSITION"
"OPTION" "OR" "ORDER" "ORDINARY" "ORGANISATION" "ORGANISE"
"ORGANIZATION" "ORIGIN" "ORIGINAL" "OTHER" "OTHERWISE" "OUGHT" "OUR"
"OURSELVES" "OUT" "OUTCOME" "OUTPUT" "OUTSIDE" "OVER" "OVERALL" "OWN"
"OWNER" "PACKAGE" "PAGE" "PAIN" "PAINT" "PAINTING" "PAIR" "PANEL"
"PAPER" "PARENT" "PARK" "PARLIAMENT" "PART" "PARTICULAR"
"PARTICULARLY" "PARTLY" "PARTNER" "PARTY" "PASS" "PASSAGE" "PAST"
"PATH" "PATIENT" "PATTERN" "PAY" "PAYMENT" "PEACE" "PENSION" "PEOPLE"
"PER" "PERCENT" "PERFECT" "PERFORM" "PERFORMANCE" "PERHAPS" "PERIOD"
"PERMANENT" "PERSON" "PERSONAL" "PERSUADE" "PHASE" "PHONE"
"PHOTOGRAPH" "PHYSICAL" "PICK" "PICTURE" "PIECE" "PLACE" "PLAN"
"PLANNING" "PLANT" "PLASTIC" "PLATE" "PLAY" "PLAYER" "PLEASE"
"PLEASURE" "PLENTY" "PLUS" "POCKET" "POINT" "POLICE" "POLICY"
"POLITICAL" "POLITICS" "POOL" "POOR" "POPULAR" "POPULATION" "POSITION"
"POSITIVE" "POSSIBILITY" "POSSIBLE" "POSSIBLY" "POST" "POTENTIAL"
"POUND" "POWER" "POWERFUL" "PRACTICAL" "PRACTICE" "PREFER" "PREPARE"
"PRESENCE" "PRESENT" "PRESIDENT" "PRESS" "PRESSURE" "PRETTY" "PREVENT"
"PREVIOUS" "PREVIOUSLY" "PRICE" "PRIMARY" "PRIME" "PRINCIPLE"
"PRIORITY" "PRISON" "PRISONER" "PRIVATE" "PROBABLY" "PROBLEM"
"PROCEDURE" "PROCESS" "PRODUCE" "PRODUCT" "PRODUCTION" "PROFESSIONAL"
"PROFIT" "PROGRAM" "PROGRAMME" "PROGRESS" "PROJECT" "PROMISE"
"PROMOTE" "PROPER" "PROPERLY" "PROPERTY" "PROPORTION" "PROPOSE"
"PROPOSAL" "PROSPECT" "PROTECT" "PROTECTION" "PROVE" "PROVIDE"
"PROVIDED" "PROVISION" "PUB" "PUBLIC" "PUBLICATION" "PUBLISH" "PULL"
"PUPIL" "PURPOSE" "PUSH" "PUT" "QUALITY" "QUARTER" "QUESTION" "QUICK"
"QUICKLY" "QUIET" "QUITE" "RACE" "RADIO" "RAILWAY" "RAIN" "RAISE"
"RANGE" "RAPIDLY" "RARE" "RATE" "RATHER" "REACH" "REACTION" "READ"
"READER" "READING" "READY" "REAL" "REALISE" "REALITY" "REALIZE"
"REALLY" "REASON" "REASONABLE" "RECALL" "RECEIVE" "RECENT" "RECENTLY"
"RECOGNISE" "RECOGNITION" "RECOGNIZE" "RECOMMEND" "RECORD" "RECOVER"
"RED" "REDUCE" "REDUCTION" "REFER" "REFERENCE" "REFLECT" "REFORM"
"REFUSE" "REGARD" "REGION" "REGIONAL" "REGULAR" "REGULATION" "REJECT"
"RELATE" "RELATION" "RELATIONSHIP" "RELATIVE" "RELATIVELY" "RELEASE"
"RELEVANT" "RELIEF" "RELIGION" "RELIGIOUS" "RELY" "REMAIN" "REMEMBER"
"REMIND" "REMOVE" "REPEAT" "REPLACE" "REPLY" "REPORT" "REPRESENT"
"REPRESENTATION" "REPRESENTATIVE" "REQUEST" "REQUIRE" "REQUIREMENT"
"RESEARCH" "RESOURCE" "RESPECT" "RESPOND" "RESPONSE" "RESPONSIBILITY"
"RESPONSIBLE" "REST" "RESTAURANT" "RESULT" "RETAIN" "RETURN" "REVEAL"
"REVENUE" "REVIEW" "REVOLUTION" "RICH" "RIDE" "RIGHT" "RING" "RISE"
"RISK" "RIVER" "ROAD" "ROCK" "ROLE" "ROLL" "ROOF" "ROOM" "ROUND"
"ROUTE" "ROW" "ROYAL" "RULE" "RUN" "RURAL" "SAFE" "SAFETY" "SALE"
"SAME" "SAMPLE" "SATISFY" "SAVE" "SAY" "SCALE" "SCENE" "SCHEME"
"SCHOOL" "SCIENCE" "SCIENTIFIC" "SCIENTIST" "SCORE" "SCREEN" "SEA"
"SEARCH" "SEASON" "SEAT" "SECOND" "SECONDARY" "SECRETARY" "SECTION"
"SECTOR" "SECURE" "SECURITY" "SEE" "SEEK" "SEEM" "SELECT" "SELECTION"
"SELL" "SEND" "SENIOR" "SENSE" "SENTENCE" "SEPARATE" "SEQUENCE"
"SERIES" "SERIOUS" "SERIOUSLY" "SERVANT" "SERVE" "SERVICE" "SESSION"
"SET" "SETTLE" "SETTLEMENT" "SEVERAL" "SEVERE" "SEX" "SEXUAL" "SHAKE"
"SHALL" "SHAPE" "SHARE" "SHE" "SHEET" "SHIP" "SHOE" "SHOOT" "SHOP"
"SHORT" "SHOT" "SHOULD" "SHOULDER" "SHOUT" "SHOW" "SHUT" "SIDE"
"SIGHT" "SIGN" "SIGNAL" "SIGNIFICANCE" "SIGNIFICANT" "SILENCE"
"SIMILAR" "SIMPLE" "SIMPLY" "SINCE" "SING" "SINGLE" "SIR" "SISTER"
"SIT" "SITE" "SITUATION" "SIZE" "SKILL" "SKIN" "SKY" "SLEEP"
"SLIGHTLY" "SLIP" "SLOW" "SLOWLY" "SMALL" "SMILE" "SO" "SOCIAL"
"SOCIETY" "SOFT" "SOFTWARE" "SOIL" "SOLDIER" "SOLICITOR" "SOLUTION"
"SOME" "SOMEBODY" "SOMEONE" "SOMETHING" "SOMETIMES" "SOMEWHAT"
"SOMEWHERE" "SON" "SONG" "SOON" "SORRY" "SORT" "SOUND" "SOURCE"
"SOUTH" "SOUTHERN" "SPACE" "SPEAK" "SPEAKER" "SPECIAL" "SPECIES"
"SPECIFIC" "SPEECH" "SPEED" "SPEND" "SPIRIT" "SPORT" "SPOT" "SPREAD"
"SPRING" "STAFF" "STAGE" "STAND" "STANDARD" "STAR" "START" "STATE"
"STATEMENT" "STATION" "STATUS" "STAY" "STEAL" "STEP" "STICK" "STILL"
"STOCK" "STONE" "STOP" "STORE" "STORY" "STRAIGHT" "STRANGE" "STRATEGY"
"STREET" "STRENGTH" "STRIKE" "STRONG" "STRONGLY" "STRUCTURE" "STUDENT"
"STUDIO" "STUDY" "STUFF" "STYLE" "SUBJECT" "SUBSTANTIAL" "SUCCEED"
"SUCCESS" "SUCCESSFUL" "SUCH" "SUDDENLY" "SUFFER" "SUFFICIENT"
"SUGGEST" "SUGGESTION" "SUITABLE" "SUM" "SUMMER" "SUN" "SUPPLY"
"SUPPORT" "SUPPOSE" "SURE" "SURELY" "SURFACE" "SURPRISE" "SURROUND"
"SURVEY" "SURVIVE" "SWITCH" "SYSTEM" "TABLE" "TAKE" "TALK" "TALL"
"TAPE" "TARGET" "TASK" "TAX" "TEA" "TEACH" "TEACHER" "TEACHING" "TEAM"
"TEAR" "TECHNICAL" "TECHNIQUE" "TECHNOLOGY" "TELEPHONE" "TELEVISION"
"TELL" "TEMPERATURE" "TEND" "TERM" "TERMS" "TERRIBLE" "TEST" "TEXT"
"THAN" "THANK" "THANKS" "THAT" "THE" "THEATRE" "THEIR" "THEM" "THEME"
"THEMSELVES" "THEN" "THEORY" "THERE" "THEREFORE" "THESE" "THEY" "THIN"
"THING" "THINK" "THIS" "THOSE" "THOUGH" "THOUGHT" "THREAT" "THREATEN"
"THROUGH" "THROUGHOUT" "THROW" "THUS" "TICKET" "TIME" "TINY" "TITLE"
"TO" "TODAY" "TOGETHER" "TOMORROW" "TONE" "TONIGHT" "TOO" "TOOL"
"TOOTH" "TOP" "TOTAL" "TOTALLY" "TOUCH" "TOUR" "TOWARDS" "TOWN"
"TRACK" "TRADE" "TRADITION" "TRADITIONAL" "TRAFFIC" "TRAIN" "TRAINING"
"TRANSFER" "TRANSPORT" "TRAVEL" "TREAT" "TREATMENT" "TREATY" "TREE"
"TREND" "TRIAL" "TRIP" "TROOP" "TROUBLE" "TRUE" "TRUST" "TRUTH" "TRY"
"TURN" "TWICE" "TYPE" "TYPICAL" "UNABLE" "UNDER" "UNDERSTAND"
"UNDERSTANDING" "UNDERTAKE" "UNEMPLOYMENT" "UNFORTUNATELY" "UNION"
"UNIT" "UNITED" "UNIVERSITY" "UNLESS" "UNLIKELY" "UNTIL" "UP" "UPON"
"UPPER" "URBAN" "US" "USE" "USED" "USEFUL" "USER" "USUAL" "USUALLY"
"VALUE" "VARIATION" "VARIETY" "VARIOUS" "VARY" "VAST" "VEHICLE"
"VERSION" "VERY" "VIA" "VICTIM" "VICTORY" "VIDEO" "VIEW" "VILLAGE"
"VIOLENCE" "VISION" "VISIT" "VISITOR" "VITAL" "VOICE" "VOLUME" "VOTE"
"WAGE" "WAIT" "WALK" "WALL" "WANT" "WAR" "WARM" "WARN" "WASH" "WATCH"
"WATER" "WAVE" "WAY" "WE" "WEAK" "WEAPON" "WEAR" "WEATHER" "WEEK"
"WEEKEND" "WEIGHT" "WELCOME" "WELFARE" "WELL" "WEST" "WESTERN" "WHAT"
"WHATEVER" "WHEN" "WHERE" "WHEREAS" "WHETHER" "WHICH" "WHILE" "WHILST"
"WHITE" "WHO" "WHOLE" "WHOM" "WHOSE" "WHY" "WIDE" "WIDELY" "WIFE"
"WILD" "WILL" "WIN" "WIND" "WINDOW" "WINE" "WING" "WINNER" "WINTER"
"WISH" "WITH" "WITHDRAW" "WITHIN" "WITHOUT" "WOMAN" "WONDER"
"WONDERFUL" "WOOD" "WORD" "WORK" "WORKER" "WORKING" "WORKS" "WORLD"
"WORRY" "WORTH" "WOULD" "WRITE" "WRITER" "WRITING" "WRONG" "YARD"
"YEAH" "YEAR" "YES" "YESTERDAY" "YET" "YOU" "YOUNG" "YOUR" "YOURSELF"
"YOUTH"))

(defconstant +trianglenums+
	     (let ((result (make-array 500)))
		  (dotimes (i 30)
			   (setf (aref result (/ (* (1+ i) (+ 2 i)) 2)) t))
		  result))


; taken from euler22
(labels (
         (wordvalue (w)
                    (apply #'+ (map 'list #'(lambda (n) (- (char-int n) 64))
                                    w))))

        (defun euler42 ()
               (length (mapcan #'(lambda (w)
                                         (when (aref +trianglenums+ (wordvalue w))
;                                        (format t "~a\n" w)
                                               (list t)))
                               +words+))))

; 4.6 msec in XLISP-PLUS. Used word value calculation from problem 22
; and created a hashtable for quick lookup of triangle numbers. I did an
; initial (apply #'max (mapcar #'wordvalue +words+)) to see how big a
; table I'd need, but made it oversized anyway.
				  
; I keep using the code from problem 23 that can go through all permutations

(defconstant +factorials+
        (let (result)
             (dotimes (i 10)
                      (push (fact i) result))
             result))

(defconstant +digits+ '(0 1 2 3 4 5 6 7 8 9)) 

(defun euler43 ()
       (labels (
		(to-factoradic (n)
			       (mapcar #'(lambda (f)
						 (let ((result (floor n f)))
						      (decf n (* result f))
						      result))
				       +factorials+))

		(permute (factoradic choices)
			 (map 'array #'(lambda (digit) (let ((result (nth digit choices)))
							    (setf choices (remove result choices))
							    result))
			      factoradic))

		(test-permute ()
			      (do* ((i 0 (1+ i))
				    (n (permute (to-factoradic i) +digits+)
				       (permute (to-factoradic i) +digits+)))
				   ((null (aref n 0)) i))) ;; reached end
		)

	       (let ((result 0))
		    (do* ((i 0 (1+ i))
			  (n (permute (to-factoradic i) +digits+)
			     (permute (to-factoradic i) +digits+)))
			 ((null (aref n 0)) result) ;; reached end
			 (when (and (evenp (aref n 3)) ; divisible by 2
				    (eql (aref n 5) 5) ; divisible by 5 and also deduction
				    ; that it can't be zero because of
				    ; divisibility by 11 test	
				    (zerop (rem (+ (* (aref n 7) 100) ; by 17
						   (* (aref n 8) 10)
						   (aref n 9)) 17))
				    (zerop (rem (+ (aref n 2) (aref n 3) (aref n 4)) 3)) ; by 3
				    (zerop (rem (+ (* (aref n 4) 100) ; by 7
						   (* (aref n 5) 10)
						   (aref n 6)) 7))
				    (zerop (rem (+ (* (aref n 5) 100) ; by 11
						   (* (aref n 6) 10)
						   (aref n 7)) 11))
				    (zerop (rem (+ (* (aref n 6) 100) ; by 13
						   (* (aref n 7) 10)
						   (aref n 8)) 13))
				    )
			       (let ((value (reduce #'(lambda (x y) (+ (* x 10) y)) n)))
				    (format t "~s\n" value)
				    (incf result value)))))))


; Brute force in XLISP-PLUS and done probably the wrong way. I
; calculated all the pandigital values and then found out which met the
; criteria. I think the other way around would have been faster! Ran in
; 54 seconds and calculating the pandigital values alone took 50. Yep,
; bad algorithm!

(defvar *pents* nil)

(defun euler44 (n) ; N is limit of number of pentagonal numbers to check
       (macrolet
	((calcpentagonal (v) `(floor (* ,v (- (* ,v 3) 1)) 2)))

	(flet ((pentagonalp (v) (zerop (rem (/ (+ (sqrt (+ (* v 24) 1)) 1) 6) 1)))

	       (fillpentarray (n) ; Create an array of pentagonal numbers
			      (setf *pents* nil)
			      (dotimes (i n)
				       (push (calcpentagonal (1+ i)) *pents*))
			      (setf *pents* (nreverse (coerce *pents* 'array)))))
	      (fillpentarray n)
	      (let (besti bestj (diff (aref *pents* (1- n))))
		   (do* ((i (1- n) (1- i)) ; go down from max
			 (ai (aref *pents* i) (aref *pents* i)))
			((zerop i))
			(do ((j (1- i) (1- j))) ; go down from j
			    ((or (< j 0) ; either no match for this i or a winning value
				 (when (and (pentagonalp (- ai (aref *pents* j)))
					    (pentagonalp (+ ai (aref *pents* j))))
				       (when (< (- ai (aref *pents* j)) diff)
					     (setf diff (- ai (aref *pents* j))
						   besti i
						   bestj j))
				       t)))))
		   (list besti bestj diff)))))

; The real issue here is what bound is needed. Luckily it appears that
; the lowest bound that produces any answer produces the correct answer.
		     
; I was originally going to calculate pentagonals on the fly, but
; decided to create an array of pentagonals. So the calcpentagonal macro
; isn't really needed.
       
(defun euler45 ()
       (let ((nt 285) ; n for each of triangle, pentagonal, and hexagonal
	     (np 165)
	     (nh 143)
	     (tn 40755) ; triangle, pentagonal, and hexagonal numbers
	     (pn 40755)
	     (hn 0))	; set to zero so we don't get first match
	    (do* ()
		 ((and (eql tn pn) (eql pn hn)) tn)
		 ; go to next hexagonal number
		 (incf nh)
		 (setf hn (* nh (- (* nh 2) 1)))
		 ; Find next triangle number >= hn
		 (do ()
		     ((>= tn hn))
		     (incf nt)
		     (setf tn (floor (* nt (1+ nt)) 2)))
		 ; Find next Pentagonal number >= hn
		 (do ()
		     ((>= pn hn))
		     (incf np)
		     (setf pn (floor (* np (1- (* np 3))) 2))))))

; In XLISP-PLUS, I stepped through all the hexagonal numbers and at
; each step I stepped through triangle numbers until >= the hexagonal
; number and stepped through the pentagonal numbers until >= the
; hexagonal number. This seemed faster than solving for n in each of the
; triangle and pentagon formulas and finding those that were integers.


(defun euler45a ()
       (let ((np 165)
	     (nh 143)
	     (pn 40755)
	     (hn 0))	; set to zero so we don't get first match
	    (do* ()
		 ((eql pn hn) pn)
		 ; go to next hexagonal number
		 (incf nh)
		 (setf hn (* nh (- (* nh 2) 1)))
		 ; Find next Pentagonal number >= hn
		 (do ()
		     ((>= pn hn))
		     (incf np)
		     (setf pn (floor (* np (1- (* np 3))) 2))))))

; After solving and reading this thread I removed the triangle number
; generation/comparison and just used pentagonal and hexagonal.
; Execution time dropped from 138 msec to 71 msec.

(defun euler45b ()
       (do* ((nh 144 (1+ nh))
	     (hn (* nh (- (* nh 2) 1)) (* nh (- (* nh 2) 1))))
	    ((zerop (rem (/ (+ (sqrt (+ (* hn 24) 1)) 1) 6) 1))
	     hn)))

; Going back and solving the quadratic equation for pentagonal numbers,
; the solution time did drop, to 41 msec.

(defun euler46 ()
       (do ((i 37 (+ i 2)))
	   ()
	   (when (null (primep i))
		 (do ((j 2 (nextprime j)))
		     ((and (< j i) (zerop (rem (sqrt (/ (- i j) 2)) 1))))
		     (when (> j i)
			   (return-from euler46 i))))))

; nextprime and primep are convienient but not optimal for this sort of
; problem. Solution time of 1.85 seconds.

;; Modified Sieve function from problems 35 and 37.
;; Gives count of distinct prime factors instead of just "T"

(defvar *notprimes*)

(defun euler47 ()
       (flet (
	      (modified-sieve (n &aux (limit (/ n 2)))
			      (setf *notprimes* (make-array n :initial-element 0))
			      (setf (aref *notprimes* 0) t)
			      (setf (aref *notprimes* 1) t)
			      (do ((i 2 (1+ i)))
				  ((> i limit))
				  (when (zerop (aref *notprimes* i))
					(do ((j (* 2 i) (+ j i)))
					    ((>= j n))
					    (incf (aref *notprimes* j)))))))

	     (modified-sieve 200000)
	     (dotimes (i 199995)
		      (when (and (eql (aref *notprimes* i) 4)
				 (eql (aref *notprimes* (1+ i)) 4)
				 (eql (aref *notprimes* (+ i 2)) 4)
				 (eql (aref *notprimes* (+ i 3)) 4))
			    (return-from euler47 i)))))

; I used a sieve, modified to count the number of different factors (a
; trivial mod). Then the solution involved just finding 4 consecutive
; '4's.

; I allowed for up to about 1,000,000, for which it took 3.86 seconds.
; Cutting back to 200,000 reduced the time to .57 seconds.


(defun euler48 ()
       (do ((result 0)
            (i 1 (1+ i)))
           ((eql i 1001)
            (rem result 10000000000))
           (incf result (expt i i))))

; I wrote and executed the solution in under a minute. Why analyze the problem?

(defun euler49 ()
       (do ((i (nextprime 1487) (nextprime i)))
	   ((> (+ i 6660) 9999))
	   (when (and (primep (+ i 3330))
		      (primep (+ i 6660))
		      (let ((s1 (sort (format nil "~s" i) #'char<)))
			   (and (equal s1 (sort (format nil "~s" (+ i 3330)) #'char<))
				(equal s1 (sort (format nil "~s" (+ i 6660)) #'char<)))))
		 (format t "~s~s~s\n" i (+ i 3330) (+ i 6660)))))

; I interpreted the problem to be that the arithmetic sequence involved
; adding 3330 at each step, and the peculiar characteristic was the
; primeness and permutation. Then I made quick work of it in
; XLISP-PLUS.

(defun euler50 ( &aux primesums)
       ; First create a list of sums of consecutive primes, with "0" at the
       ; start of the list
       (setf primesums '(0))
       (do ((i 2 (nextprime i)))
	   ((> i 1000000))
	   (push (+ (first primesums) i) primesums))
       (setf primesums (nreverse (coerce primesums 'array)))
       (let ((maxseq 0) (prime 0) testval)
	    (do ((i 1 (1+ i))) ;; loop through all sums (from "2") in list
		((eql i (length primesums)))
		(do ((j (1- i) (1- j))) ;; loop for all preceding sums and
				        ;; check the differences for being prime
		    ((or (< j 0)
			 (> (setf testval (- (aref primesums i)(aref primesums j)))
			    1000000)))
		    (when (and (primep testval) ;; If prime and longer sequence, use it
			       (> (- i j) maxseq))
			  (setf maxseq (- i j) prime testval))))
	    (list (1+ maxseq) prime)))


; Using a sieve speeds things up by a factor of 4.

; (defvar *notprimes*) ; previously defined
(defvar *primesums*)

; Sieve modified to create sum of primes as well as the sieve
; which will be used for checking if a number is prime

(defun euler50a ()
       (flet ((sieve (n &aux (limit (/ n 2)))
		     (setf *notprimes* (make-array n))
		     (setf *primesums* '(0))
		     (setf (aref *notprimes* 0) t)
		     (setf (aref *notprimes* 1) t)
		     (do ((i 2 (1+ i)))
			 ((> i limit))
			 (when (null (aref *notprimes* i))
			       (push (+ (first *primesums*) i) *primesums*)
			       (do ((j (* 2 i) (+ j i)))
				   ((>= j n))
				   (setf (aref *notprimes* j) t))))
		     (setf *primesums* (nreverse (coerce *primesums* 'array)))))

	     (sieve 999999)
	     (let ((maxseq 0) (prime 0) testval)
		  (do ((i 1 (1+ i))) ;; loop through all sums (from "2") in list
		      ((eql i (length *primesums*)))
		      (do ((j (1- i) (1- j))) ;; loop for all preceding sums and
			  ;; check the differences for being prime
			  ((or (< j 0)
			       (> (setf testval (- (aref *primesums* i)(aref *primesums* j)))
				  999998)))
			  (when (and (null (aref *notprimes* testval)) ;; If prime and longer sequence, use it
				     (> (- i j) maxseq))
				(setf maxseq (- i j) prime testval))))
		  (list (1+ maxseq) prime))))



(in-package "USER")
